% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-information-criteria.R
\name{ols_hsp}
\alias{ols_hsp}
\title{Hocking's Sp}
\usage{
ols_hsp(model)
}
\arguments{
\item{model}{An object of class \code{lm}.}
}
\value{
Hocking's Sp of the model.
}
\description{
Average prediction mean squared error.
}
\details{
Hocking's Sp criterion is an adjustment of the residual sum of
Squares. Minimize this criterion.

\deqn{MSE / (n - p - 1)}

where \eqn{MSE = SSE / (n - p)}, n is the sample size and p is the number of predictors including the intercept
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_hsp(model)

}
\references{
Hocking, R. R. (1976). “The Analysis and Selection of Variables in a Linear Regression.” Biometrics
32:1–50.
}
\seealso{
Other model selection criteria: \code{\link{ols_aic}},
  \code{\link{ols_apc}}, \code{\link{ols_fpe}},
  \code{\link{ols_mallows_cp}}, \code{\link{ols_msep}},
  \code{\link{ols_sbc}}, \code{\link{ols_sbic}}
}
