% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{encode_olc}
\alias{encode_olc}
\title{Encode Latitude and Longitude Pairs as Open Location Codes}
\usage{
encode_olc(lats, longs, length)
}
\arguments{
\item{lats}{a numeric vector of latitudes.}

\item{longs}{a numeric vector of longitudes, equivalent in size to \code{lats}}

\item{length}{the length you want the resulting OLCs to be. The conventional lengths
are 10 or 11, with any number above 8 and any \emph{even} number below it being acceptable. \code{length}
should consist of either a single value, if you want all codes to be calculated to the same length, or a
vector of values the same size as \code{lats} and \code{longs} if you want to pre-set values.}
}
\description{
\code{encode_olc} creates Open Location Codes from
latitude and longitude values, of a specified length.
}
\examples{
encode_olc(20.375, 2.775,6)
}
\seealso{
\code{\link{decode_olc}} for the opposite operation, and \code{\link{shorten_olc}} to convert
"full" Open Location Codes to "short" Open Location Codes.
}

