% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_acoustic_data.R
\name{summarize_acoustic_data}
\alias{summarize_acoustic_data}
\title{Summarize information about file format in an acoustic data set}
\usage{
summarize_acoustic_data(path = ".", digits = 2)
}
\arguments{
\item{path}{Character string containing the directory path where the sound files are located. Default is \code{"."} (current working directory).}

\item{digits}{Numeric vector of length 1 with the number of decimals to include. Default is 2.}
}
\value{
The function prints a summary of the format of the files in an acoustic data set.
}
\description{
\code{summarize_acoustic_data} summarizes information about file format in an acoustic data set
}
\details{
The function summarizes information about file format in an acoustic data set. It provides information about the number of files, file formats, sampling rates, bit depts, channels, duration and file size (in MB). For file format, sampling rate, bit depth and number of channels the function includes information about the number of files for each format (e.g. '44.1 kHz (2)' means 2 files with a sampling rate of 44.1 kHz).
}
\examples{
{
  # load data and save example files into temporary working directory
  data("lbh1", "lbh2", "lbh_reference")
  tuneR::writeWave(lbh1, file.path(tempdir(), "lbh1.wav"))
  tuneR::writeWave(lbh2, file.path(tempdir(), "lbh2.wav"))

  # summary across sound files
  summarize_acoustic_data(path = tempdir())
}
}
\references{
Araya-Salas, M., Smith-Vidaurre, G., Chaverri, G., Brenes, J. C., Chirino, F., Elizondo-Calvo, J., & Rico-Guevara, A. (2023). ohun: An R package for diagnosing and optimizing automatic sound event detection. Methods in Ecology and Evolution, 14, 2259–2271. https://doi.org/10.1111/2041-210X.14170
}
\seealso{
\code{\link{summarize_reference}}
}
\author{
Marcelo Araya-Salas \email{marcelo.araya@ucr.ac.cr})
}
