% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linodds.r
\name{as.linodds}
\alias{as.linodds}
\alias{predict.linodds}
\alias{coef.linodds}
\title{An object for modeling linear odds.}
\usage{
as.linodds(object, formula, beta)

\method{predict}{linodds}(object, newdata, type = c("eta", "mu",
  "erank"), na.action = na.pass, group = NULL, ...)

\method{coef}{linodds}(object, ...)
}
\arguments{
\item{object}{some list-like object.}

\item{formula}{an object of class \code{"\link{formula}"} (or one that
    can be coerced to that class): a symbolic description of the
    model to be fitted.  The details of model specification are given
    under \sQuote{Details}.}

\item{beta}{the fit coefficients.}

\item{newdata}{a \code{data.frame} from which we can extract a model
frame via the formula of the \code{object}.}

\item{type}{indicates which prediction should be returned:
\describe{
\item{\code{eta}}{The odds.}
\item{\code{mu}}{The probability.}
\item{\code{erank}}{The expected rank.}
}}

\item{na.action}{How to deal with missing values in \code{y}, \code{g},
\code{X}, \code{wt}, \code{eta0}.}

\item{group}{the string name of the group variable in the data,
or a bare character with the group name. The group indices
need not be integers, but that is more efficient. 
They need not be sorted.}

\item{...}{other arguments.}
}
\description{
A model for odds linear in some feature.
}
\details{
An object which holds a formula, some fit coefficients 
\eqn{\beta} which fit in that formula to generate odds
in odds space. 
The odds can then be converted, via \code{predict.linodds}
to probabilities, 
or to expected ranks under the Harville model.
Both \code{\link{harsm}} and \code{\link{hensm}} return
objects of class \code{linodds}.

We think of linear odds as 
\eqn{\eta = x^{\top}\beta},
for independent variables \eqn{x}. The odds, \eqn{\eta}
are converted to probabilities, \eqn{\mu} via
\eqn{\mu = c \exp{\eta},} where the constant \eqn{c}
is chosen so the \eqn{\mu} for a given matching
sum to one.
}
\seealso{
\code{\link{harsm}}, \code{\link{hensm}}.

\code{\link{smax}}, \code{\link{harsm_invlink}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
