% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{best_picture}
\alias{best_picture}
\title{Oscar Award Best Picture Data}
\format{A \code{data.frame} object with 484 observations and 19 columns. 
The columns are defined as follows:
\describe{
 \item{\code{year}}{The integer year of the nomination. These span from 1934 through 2014. Note that the
 number of films nominated per year varies from 5 to 12.}
 \item{\code{film}}{The title of the film.}
 \item{\code{winner}}{A logical for whether the film won the Oscar for Best
 Picture. There is exactly one winning film per year.}
 \item{\code{nominated_for_Writing}}{A logical indicating whether the film
 was also nominated for a Writing award that year.}
 \item{\code{nominated_for_BestDirector}}{A logical indicating whether the film
 was also nominated for Best Director award that year.}
 \item{\code{nominated_for_BestActress}}{A logical indicating whether the film
 was also nominated for at least one Best Actress award that year.}
 \item{\code{nominated_for_BestActor}}{A logical indicating whether the film
 was also nominated for at least one Best Actor award that year.}
 \item{\code{nominated_for_BestFilmEditing}}{A logical indicating whether the film
 was also nominated for at least one Best Film Editing award that year.}
 \item{\code{Adventure}}{A double computed as a 0/1 indicator of whether
 \dQuote{Adventure} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{Biography}}{A double computed as a 0/1 indicator of whether
 \dQuote{Biography} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{Comedy}}{A double computed as a 0/1 indicator of whether
 \dQuote{Comedy} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{Crime}}{A double computed as a 0/1 indicator of whether
 \dQuote{Crime} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{Drama}}{A double computed as a 0/1 indicator of whether
 \dQuote{Drama} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{History}}{A double computed as a 0/1 indicator of whether
 \dQuote{History} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{Musical}}{A double computed as a 0/1 indicator of whether
 \dQuote{Musical} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{Romance}}{A double computed as a 0/1 indicator of whether
 \dQuote{Romance} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{Thriller}}{A double computed as a 0/1 indicator of whether
 \dQuote{Thriller} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{War}}{A double computed as a 0/1 indicator of whether
 \dQuote{War} was one of the genres tagged for the film in IMDb,
 divided by the total count of genres tagged for the film.}
 \item{\code{Other}}{A double computed as 1 minus the sum of
 the other genre indicators. Effectively this is is the
 sum of indicators for
 \dQuote{Mystery}, \dQuote{Family}, \dQuote{Fantasy}, 
 \dQuote{Action}, \dQuote{Western}, \dQuote{Music}, 
 \dQuote{Sport}, \dQuote{Sci Fi},  \dQuote{Film-Noir},
 \dQuote{Animation}, and \dQuote{Horror} divided
 by the total count of genres tagged for the film.}
}}
\source{
Awards data were sourced from Wikipedia, while genre data were
sourced from IMDb.
Any errors in transcription are the fault of the package author.
}
\usage{
data(best_picture)
}
\description{
Historical data on the Best Picture nominees and winners
from 1934 through 2014.
}
\note{
\dQuote{Oscar} is a copyright property of the Academy of Motion
Picture Arts and Sciences. 
IMDb is owned by Amazon.
}
\examples{

library(dplyr)
data(best_picture)

best_picture \%>\% 
  group_by(nominated_for_BestDirector) \%>\% 
  summarize(propwin=mean(winner)) \%>\% 
  ungroup()
best_picture \%>\% 
  group_by(nominated_for_BestActor) \%>\% 
  summarize(propwin=mean(winner)) \%>\% 
  ungroup()
# hmmmm.
best_picture \%>\% 
  group_by(nominated_for_BestActress) \%>\% 
  summarize(propwin=mean(winner)) \%>\% 
 ungroup()

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{data}
