% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_docx.R
\name{docx_summary}
\alias{docx_summary}
\title{Get Word content in a data.frame}
\usage{
docx_summary(x, preserve = FALSE)
}
\arguments{
\item{x}{an rdocx object}

\item{preserve}{If \code{FALSE} (default), text in table cells is collapsed into a
single line. If \code{TRUE}, line breaks in table cells are preserved as a "\\n"
character. This feature is adapted from \code{docxtractr::docx_extract_tbl()}
published under a \href{https://github.com/hrbrmstr/docxtractr/blob/master/LICENSE}{MIT licensed} in
the \code{{docxtractr}} package by Bob Rudis.}
}
\description{
read content of a Word document and
return a data.frame representing the document.
}
\note{
Documents included with \code{body_add_docx()} will
not be accessible in the results.
}
\examples{
example_pptx <- system.file(package = "officer",
  "doc_examples/example.docx")
doc <- read_docx(example_pptx)

docx_summary(doc)

docx_summary(doc, preserve = TRUE)[28, ]
}
