% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with_methods.R
\name{ph_with}
\alias{ph_with}
\alias{ph_with.character}
\alias{ph_with.numeric}
\alias{ph_with.factor}
\alias{ph_with.logical}
\alias{ph_with.block_list}
\alias{ph_with.unordered_list}
\alias{ph_with.data.frame}
\alias{ph_with.gg}
\alias{ph_with.external_img}
\alias{ph_with.fpar}
\alias{ph_with.xml_document}
\title{add objects into a new shape on the current slide}
\usage{
ph_with(x, value, ...)

\method{ph_with}{character}(x, value, location, ...)

\method{ph_with}{numeric}(x, value, location, format_fun = format, ...)

\method{ph_with}{factor}(x, value, location, ...)

\method{ph_with}{logical}(x, value, location, format_fun = format, ...)

\method{ph_with}{block_list}(x, value, location, ...)

\method{ph_with}{unordered_list}(x, value, location, ...)

\method{ph_with}{data.frame}(x, value, location, header = TRUE,
  first_row = TRUE, first_column = FALSE, last_row = FALSE,
  last_column = FALSE, ...)

\method{ph_with}{gg}(x, value, location, ...)

\method{ph_with}{external_img}(x, value, location, use_loc_size = TRUE,
  ...)

\method{ph_with}{fpar}(x, value, location, ...)

\method{ph_with}{xml_document}(x, value, location, ...)
}
\arguments{
\item{x}{an rpptx object}

\item{value}{object to add as a new shape. Supported objects
are vectors, data.frame, graphics, block of formatted paragraphs,
unordered list of formatted paragraphs,
pretty tables with package flextable, editable graphics with
package rvg, 'Microsoft' charts with package mschart.}

\item{...}{Arguments to be passed to methods}

\item{location}{a placeholder location object.
It will be used to specify the location of the new shape. This location
can be defined with a call to one of the ph_location functions. See
section \code{see also}.}

\item{format_fun}{format function for non character vectors}

\item{header}{display header if TRUE}

\item{first_row, last_row, first_column, last_column}{logical for PowerPoint table options}

\item{use_loc_size}{if set to FALSE, external_img width and height will
be used.}
}
\description{
add object into a new shape in the current slide. This
function is able to add all supported outputs to a presentation
and should replace calls to older functions starting with
\code{ph_with_*}.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: add a character vector to a new shape on the
current slide, values will be added as paragraphs.

\item \code{numeric}: add a numeric vector to a new shape on the
current slide, values will be be first formatted then
added as paragraphs.

\item \code{factor}: add a factor vector to a new shape on the
current slide, values will be be converted as character and then
added as paragraphs.

\item \code{block_list}: add a \code{\link{block_list}} made
of \code{\link{fpar}} to a new shape on the current slide.

\item \code{unordered_list}: add a \code{\link{unordered_list}} made
of \code{\link{fpar}} to a new shape on the current slide.

\item \code{data.frame}: add a data.frame to a new shape on the current slide. Use
package \code{flextable} instead for more advanced formattings.

\item \code{gg}: add a ggplot object to a new shape on the
current slide. Use package \code{rvg} for more advanced graphical features.

\item \code{external_img}: add a \code{\link{external_img}} to a new shape
on the current slide.

When value is a external_img object, image will be copied
into the PowerPoint presentation. The width and height
specified in call to \code{external_img} will be
ignored, their values will be those of the location,
unless use_loc_size is set to FALSE.

\item \code{fpar}: add an \code{\link{fpar}} to a new shape
on the current slide as a single paragraph in a \code{\link{block_list}}.

\item \code{xml_document}: add an xml_document object to a new shape on the
current slide. This function is to be used to add custom openxml code.
}}

\examples{
fileout <- tempfile(fileext = ".pptx")
doc <- read_pptx()
doc <- add_slide(doc, layout = "Two Content",
  master = "Office Theme")
doc <- ph_with(x = doc, value = c("Un titre", "Deux titre"),
               location = ph_location_left() )
doc <- ph_with(x = doc, value = iris[1:4, 3:5],
               location = ph_location_right() )

if( require("ggplot2") ){
  doc <- add_slide(doc)
  gg_plot <- ggplot(data = iris ) +
    geom_point(mapping = aes(Sepal.Length, Petal.Length),
      size = 3) +
    theme_minimal()
  doc <- ph_with(x = doc, value = gg_plot,
                 location = ph_location_fullsize() )
  doc <- ph_with(x = doc, value = "graphic title",
               location = ph_location_type(type="title") )
}

doc <- add_slide(doc, layout = "Title and Content",
  master = "Office Theme")
img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
doc <- ph_with(x = doc, external_img(img.file, 100/72, 76/72),
               location = ph_location_right(), use_loc_size = FALSE )

svg_file <- file.path(R.home(component = "doc"), "html/Rlogo.svg")
if( require("rsvg") ){
  doc <- ph_with(x = doc, external_img(svg_file),
    location = ph_location_left(),
    use_loc_size = TRUE )
}
# block list ------
bl <- block_list(
  fpar(ftext("hello world", shortcuts$fp_bold(color = "pink"))),
  fpar(
    ftext("hello", shortcuts$fp_bold()),
    ftext("hello", shortcuts$fp_italic(color="red"))
  ))
doc <- add_slide(doc)
doc <- ph_with(x = doc, value = bl,
               location = ph_location_type(type="body") )

# fpar ------
hw <- fpar(ftext("hello world", shortcuts$fp_bold(color = "pink")))
doc <- add_slide(doc)
doc <- ph_with(x = doc, value = hw,
               location = ph_location_type(type="body") )
# unordered_list ----
ul <- unordered_list(
  level_list = c(1, 2, 2, 3, 3, 1),
  str_list = c("Level1", "Level2", "Level2", "Level3", "Level3", "Level1"),
  style = fp_text(color = "red", font.size = 0) )
doc <- add_slide(doc)
doc <- ph_with(x = doc, value = ul,
               location = ph_location_fullsize() )

print(doc, target = fileout )
}
\seealso{
\link{ph_location_type}, \link{ph_location}, \link{ph_location_label},
\link{ph_location_left}, \link{ph_location_right}, \link{ph_location_fullsize},
\link{ph_location_template}
}
