% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add}
\alias{body_add}
\alias{body_add.character}
\alias{body_add.numeric}
\alias{body_add.factor}
\alias{body_add.fpar}
\alias{body_add.data.frame}
\alias{body_add.block_caption}
\alias{body_add.block_list}
\alias{body_add.block_toc}
\alias{body_add.external_img}
\alias{body_add.run_pagebreak}
\alias{body_add.run_columnbreak}
\alias{body_add.gg}
\alias{body_add.plot_instr}
\alias{body_add.block_pour_docx}
\alias{body_add.block_section}
\title{Add content into a Word document}
\usage{
body_add(x, value, ...)

\method{body_add}{character}(x, value, style = NULL, ...)

\method{body_add}{numeric}(x, value, style = NULL, format_fun = formatC, ...)

\method{body_add}{factor}(x, value, style = NULL, format_fun = as.character, ...)

\method{body_add}{fpar}(x, value, style = NULL, ...)

\method{body_add}{data.frame}(
  x,
  value,
  style = NULL,
  header = TRUE,
  tcf = table_conditional_formatting(),
  alignment = NULL,
  ...
)

\method{body_add}{block_caption}(x, value, ...)

\method{body_add}{block_list}(x, value, ...)

\method{body_add}{block_toc}(x, value, ...)

\method{body_add}{external_img}(x, value, style = "Normal", ...)

\method{body_add}{run_pagebreak}(x, value, style = NULL, ...)

\method{body_add}{run_columnbreak}(x, value, style = NULL, ...)

\method{body_add}{gg}(x, value, width = 6, height = 5, res = 300, style = "Normal", ...)

\method{body_add}{plot_instr}(x, value, width = 6, height = 5, res = 300, style = "Normal", ...)

\method{body_add}{block_pour_docx}(x, value, ...)

\method{body_add}{block_section}(x, value, ...)
}
\arguments{
\item{x}{an rdocx object}

\item{value}{object to add in the document. Supported objects
are vectors, data.frame, graphics, block of formatted paragraphs,
unordered list of formatted paragraphs,
pretty tables with package flextable, 'Microsoft' charts with package mschart.}

\item{...}{further arguments passed to or from other methods. When
adding a \code{ggplot} object or \link{plot_instr}, these arguments will be used
by png function. See method signatures to see what arguments can be used.}

\item{style}{paragraph style name. These names are available with function \link{styles_info}
and are the names of the Word styles defined in the base document (see
argument \code{path} from \link{read_docx}).}

\item{format_fun}{a function to be used to format values.}

\item{header}{display header if TRUE}

\item{tcf}{conditional formatting settings defined by \code{\link[=table_conditional_formatting]{table_conditional_formatting()}}}

\item{alignment}{columns alignement, argument length must match with columns length,
values must be "l" (left), "r" (right) or "c" (center).}

\item{width}{height in inches}

\item{height}{height in inches}

\item{res}{resolution of the png image in ppi}
}
\description{
This function add objects into a Word document. Values are added
as new paragraphs or tables.

This function is experimental and will replace the \verb{body_add_*} functions
later. For now it is only to be used for successive additions and cannot
be used in conjunction with the \verb{body_add_*} functions.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: add a character vector.

\item \code{numeric}: add a numeric vector.

\item \code{factor}: add a factor vector.

\item \code{fpar}: add a \link{fpar} object. These objects enable
the creation of formatted paragraphs made of formatted chunks of text.

\item \code{data.frame}: add a data.frame object with \code{\link[=block_table]{block_table()}}.

\item \code{block_caption}: add a \link{block_caption} object. These objects enable
the creation of set of formatted paragraphs made of formatted chunks of text.

\item \code{block_list}: add a \link{block_list} object.

\item \code{block_toc}: add a table of content (a \link{block_toc} object).

\item \code{external_img}: add an image (a \link{external_img} object).

\item \code{run_pagebreak}: add a \link{run_pagebreak} object.

\item \code{run_columnbreak}: add a \link{run_columnbreak} object.

\item \code{gg}: add a ggplot object.

\item \code{plot_instr}: add a base plot with a \link{plot_instr} object.

\item \code{block_pour_docx}: pour content of an external docx file with with a \link{block_pour_docx} object

\item \code{block_section}: ends a section with a \link{block_section} object
}}

\section{Illustrations}{


\if{html}{\figure{body_add_doc_1.png}{options: width=70\%}}
}

\examples{
doc_1 <- read_docx()
doc_1 <- body_add(doc_1, "Table of content", style = "heading 1")
doc_1 <- body_add(doc_1, block_toc())
doc_1 <- body_add(doc_1, run_pagebreak())
doc_1 <- body_add(doc_1, "A title", style = "heading 1")
doc_1 <- body_add(doc_1, head(iris), style = "table_template")
doc_1 <- body_add(doc_1, "Another title", style = "heading 1")
doc_1 <- body_add(doc_1, letters, style = "Normal")
doc_1 <- body_add(doc_1,
  block_section(prop_section(type = "continuous"))
)
doc_1 <- body_add(doc_1, plot_instr(code = barplot(1:5, col = 2:6)))
doc_1 <- body_add(doc_1,
  block_section(prop_section(page_size = page_size(orient = "landscape")))
)
print(doc_1, target = tempfile(fileext = ".docx"))
# print(doc_1, target = "test.docx")
}
