% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_replace.R
\name{body_replace_all_text}
\alias{body_replace_all_text}
\alias{headers_replace_all_text}
\alias{footers_replace_all_text}
\title{Replace text anywhere in the document, or at a cursor}
\usage{
body_replace_all_text(
  x,
  old_value,
  new_value,
  only_at_cursor = FALSE,
  warn = TRUE,
  ...
)

headers_replace_all_text(
  x,
  old_value,
  new_value,
  only_at_cursor = FALSE,
  warn = TRUE,
  ...
)

footers_replace_all_text(
  x,
  old_value,
  new_value,
  only_at_cursor = FALSE,
  warn = TRUE,
  ...
)
}
\arguments{
\item{x}{a docx device}

\item{old_value}{the value to replace}

\item{new_value}{the value to replace it with}

\item{only_at_cursor}{if \code{TRUE}, only search-and-replace at the current
cursor; if \code{FALSE} (default), search-and-replace in the entire document
(this can be slow on large documents!)}

\item{warn}{warn if \code{old_value} could not be found.}

\item{...}{optional arguments to grepl/gsub (e.g. \code{fixed=TRUE})}
}
\description{
Replace all occurrences of old_value with new_value. This method
uses \code{\link{grepl}}/\code{\link{gsub}} for pattern matching; you may
supply arguments as required (and therefore use \code{\link{regex}} features)
using the optional \code{...} argument.

Note that by default, grepl/gsub will use \code{fixed=FALSE}, which means
that \code{old_value} and \code{new_value} will be interepreted as regular
expressions.

\strong{Chunking of text}

Note that the behind-the-scenes representation of text in a Word document is
frequently not what you might expect! Sometimes a paragraph of text is broken
up (or "chunked") into several "runs," as a result of style changes, pauses
in text entry, later revisions and edits, etc. If you have not styled the
text, and have entered it in an "all-at-once" fashion, e.g. by pasting it or
by outputing it programmatically into your Word document, then this will
likely not be a problem. If you are working with a manually-edited document,
however, this can lead to unexpected failures to find text.

You can use the officer function \code{\link{docx_show_chunk}} to
show how the paragraph of text at the current cursor has been chunked into
runs, and what text is in each chunk. This can help troubleshoot unexpected
failures to find text.
}
\section{header_replace_all_text}{

Replacements will be performed in each header of all sections.


Replacements will be performed in each footer of all sections.
}

\examples{
library(magrittr)

doc <- read_docx() \%>\%
  body_add_par("Placeholder one") \%>\%
  body_add_par("Placeholder two")

# Show text chunk at cursor
docx_show_chunk(doc)  # Output is 'Placeholder two'

# Simple search-and-replace at current cursor, with regex turned off
doc <- body_replace_all_text(doc, old_value = "Placeholder",
  new_value = "new", only_at_cursor = TRUE, fixed = TRUE)
docx_show_chunk(doc)  # Output is 'new two'

# Do the same, but in the entire document and ignoring case
doc <- body_replace_all_text(doc, old_value = "placeholder",
  new_value = "new", only_at_cursor=FALSE, ignore.case = TRUE)
doc <- cursor_backward(doc)
docx_show_chunk(doc) # Output is 'new one'

# Use regex : replace all words starting with "n" with the word "example"
doc <- body_replace_all_text(doc, "\\\\bn.*?\\\\b", "example")
docx_show_chunk(doc) # Output is 'example one'
}
\seealso{
\code{\link{grep}}, \code{\link{regex}}, \code{\link{docx_show_chunk}}
}
\author{
Frank Hangler, \email{frank@plotandscatter.com}
}
