% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.1.111.R
\name{od.1.111}
\alias{od.1.111}
\title{Optimal sample allocation calculation for single-level randomized controlled
    trials (RCTs) investigating mediation effects (1-1-1)}
\usage{
od.1.111(
  a = NULL,
  b = NULL,
  c = NULL,
  ct = NULL,
  m = NULL,
  r.yx = 0,
  r.mx = 0,
  r.mw = 0,
  q.a = 0,
  q.b = 0,
  test = "joint",
  p = NULL,
  n = NULL,
  tol = 1e-11,
  power = 0.8,
  d.p = c(0.1, 0.5),
  sig.level = 0.05,
  two.tailed = TRUE,
  plim = c(0.01, 0.99),
  varlim = c(0, 0.001),
  plab = NULL,
  varlab = NULL,
  vartitle = NULL,
  nlim = c(6, 1e+06),
  verbose = TRUE,
  max.value = Inf,
  max.iter = 300,
  e = 1e-10,
  n.of.ants = 10,
  n.of.archive = 20,
  q = 1e-04,
  xi = 0.5
)
}
\arguments{
\item{a}{The treatment effect on the mediator.}

\item{b}{The within-treatment correlation between the outcome and
the mediator.}

\item{c}{The cost of sampling an individual in the control group.}

\item{ct}{The cost of sampling an individual in the treated group.}

\item{m}{Total budget.}

\item{r.yx}{The within-treatment correlation between the outcome and the
covariate(s) in the outcome model.}

\item{r.mx}{The within-treatment correlation between the mediator and the
covariate(s) in the outcome model.}

\item{r.mw}{The within-treatment correlation between the mediator and the
covariate(s) in the mediator model.}

\item{q.a}{The number of covariates at the mediator model
(except the treatment indicator), the default value is zero.}

\item{q.b}{The number of covariates in the outcome model (except the treatment
indicator and the mediator), the default value is zero.}

\item{test}{The type of test will be used to detect mediation effects.
The default is the joint significance test (i.e., test = "joint",
"Joint","JOINT"). Another choice is the Sobel test by
specifying the argument as test = "sobel", "Sobel", or "SOBEL".}

\item{p}{The proportion of level-4 clusters/units to be assigned to treatment.}

\item{n}{Total number of individuals in the experimental study, the default
value is NULL.}

\item{tol}{convergence tolerance.}

\item{power}{Statistical power specified, default is .80.}

\item{d.p}{The initial sampling domains for p. Default is c(0.10, 0.50).}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Two tailed test, the default value is TRUE.}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{varlim}{The plot range for variance, default value is c(0, 0.05).}

\item{plab}{The plot label for \code{p} ,
default value is "Proportion of Individuals in Treatment: p".}

\item{varlab}{The plot label for variance,
default value is "Variance".}

\item{vartitle}{The title of variance plot, default value is NULL.}

\item{nlim}{The interval/range used to numerically solve for n,
the default values are c(6, 1e7).}

\item{verbose}{Print out evaluation process if TRUE, default is TRUE.}

\item{max.value}{Maximal value of optimization when used as
the stopping criterion. Default is infinite.}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion. Default is 200.}

\item{e}{Maximum error value used when solution quality used as
the stopping criterion, default is 1e-10.}

\item{n.of.ants}{Number of ants used in each iteration after
the initialization stage, the default value is 10.}

\item{n.of.archive}{Size of the solution archive, default is 20.}

\item{q}{Locality of the search (0,1), default is 0.0001.}

\item{xi}{Convergence pressure (0, Inf), suggested: (0, 1), default is 0.5.}
}
\value{
Unconstrained or constrained optimal sample allocation \code{p}).
    The function also returns statistical power,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of single-level RCTs
    probing mediation effects is to identify the optimal sample
    allocation that use the minimum budget to achieve a fixed level of
    statistical power. The optimal design parameter is the proportion of
    individuals/units to be assigned to the experimental condition.
    This function identifies the optimal \code{p}.
}
\examples{
myod <- od.1.111(a = .3, b = .5, c = 10, ct = 100)
myod
}
