% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataTypes.R
\name{odbcDataType}
\alias{odbcDataType}
\title{Return the corresponding ODBC data type for an R object}
\usage{
odbcDataType(con, obj, ...)
}
\arguments{
\item{con}{A driver connection object, as returned by \code{dbConnect()}.}

\item{obj}{An R object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
Corresponding SQL type for the \code{obj}.
}
\description{
This is used when creating a new table with \code{dbWriteTable()}.
Databases with default methods defined are
\itemize{
\item MySQL
\item PostgreSQL
\item SQL Server
\item SQLite
\item Spark
\item Hive
\item Impala
\item Redshift
\item Vertica
}
}
\details{
If you are using a different database and \code{dbWriteTable()} fails with a SQL
parsing error the default method is not appropriate, you will need to write
a new method.
}
\section{Defining a new dbDataType method}{


The object type for your connection will be the database name retrieved by
\code{dbGetInfo(con)$dbms.name}. Use the documentation provided with your
database to determine appropriate values for each R data type. An example
method definition of a fictional \code{foo} database follows.\preformatted{con <- dbConnect(odbc::odbc(), "FooConnection")
dbGetInfo(con)$dbms.name
#> [1] "foo"

`odbcDataType.foo <- function(con, obj, ...) {
  switch_type(obj,
    factor = "VARCHAR(255)",
    datetime = "TIMESTAMP",
    date = "DATE",
    binary = "BINARY",
    integer = "INTEGER",
    double = "DOUBLE",
    character = "VARCHAR(255)",
    logical = "BIT",
    list = "VARCHAR(255)",
    stop("Unsupported type", call. = FALSE)
  )
}
}
}

