% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobo.R
\name{summary,lobo-method}
\alias{summary,lobo-method}
\title{Summarize a lobo Object}
\usage{
\S4method{summary}{lobo}(object, ...)
}
\arguments{
\item{object}{a \linkS4class{lobo} object.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
A matrix containing statistics of the elements of the \code{data}
slot.
}
\description{
Pertinent summary information is presented, including the sampling interval,
data ranges, etc.
}
\examples{

library(oce)
data(lobo)
summary(lobo)
}
\seealso{
The documentation for \linkS4class{lobo} explains the
structure of LOBO objects, and also outlines the other functions dealing
with them.

Other things related to lobo data: 
\code{\link{[[,lobo-method}},
\code{\link{[[<-,lobo-method}},
\code{\link{as.lobo}()},
\code{\link{lobo-class}},
\code{\link{lobo}},
\code{\link{plot,lobo-method}},
\code{\link{read.lobo}()},
\code{\link{subset,lobo-method}}
}
\author{
Dan Kelley
}
\concept{things related to lobo data}
