% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.copernicus.R
\name{read.argo.copernicus}
\alias{read.argo.copernicus}
\title{Read an argo File in Copernicus Format}
\usage{
read.argo.copernicus(
  file,
  encoding = NA,
  debug = getOption("oceDebug"),
  processingLog,
  ...
)
}
\arguments{
\item{file}{A character string giving the name of the file to load.}

\item{encoding}{ignored.}

\item{debug}{A flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or 0 (the default) for silent operation.}

\item{processingLog}{ignored.}

\item{...}{ignored.}
}
\description{
This function was added to read a particular file downloaded from the
Fleet Monitoring website (Reference 1).  The format was inferred
through examination of the file and a brief study of a document
(Reference 2) that describes the format.  Not all fields are read
by this function; see Reference 3 for a full list and note that
the author would be happy to add new entries (but not to spend hours
entering then all).
}
\references{
\enumerate{
\item \verb{https://fleetmonitoring.euro-argo.eu/float/4902489}
\item Copernicus Marine In Situ Tac Data Management Team. Copernicus Marine In
Situ NetCDF Format Manual (version V1.43). Pdf. Copernicus in situ TAC, 2021.
\verb{https://doi.org/10.13155/59938} (link checked 2022-04-11).
\item Variable names are provided in files at
\verb{https://doi.org/10.13155/53381} (link checked 2022-04-12)
}
}
\seealso{
Other things related to argo data: 
\code{\link{[[,argo-method}},
\code{\link{[[<-,argo-method}},
\code{\link{argo-class}},
\code{\link{argoGrid}()},
\code{\link{argoNames2oceNames}()},
\code{\link{argo}},
\code{\link{as.argo}()},
\code{\link{handleFlags,argo-method}},
\code{\link{plot,argo-method}},
\code{\link{read.argo}()},
\code{\link{subset,argo-method}},
\code{\link{summary,argo-method}}
}
\author{
Dan Kelley
}
\concept{things related to argo data}
