% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{as.unit}
\alias{as.unit}
\title{Convert a String to a Unit}
\usage{
as.unit(u, default = list(unit = expression(), scale = ""))
}
\arguments{
\item{u}{A character string indicating a unit. Case is ignored, so that e.g.
\code{"dbar"} and \code{"DBAR"} yield equal results.  The following are recognized:
c(\code{"m-1"}, \code{"dbar"}, \code{"decibar"}, \code{"degree"}, \code{"degree_Celcius"},
\code{"degree_north"}, \code{"degree_east"}, \code{"ipts-68"},
\code{"its-90"}, \code{"m/s^1"}, \code{"m/s^2"}, \code{"pss-78"},
\code{"umol/kg"}, \code{"micromole/kg"})}

\item{default}{A default to be used for the return value, if \code{u}
is not a recognized string.}
}
\value{
A list with elements \code{unit}, an \code{\link[=expression]{expression()}},
and \code{scale}, a string.
}
\description{
This converts strings to unit objects.  Only a few strings are recognized,
because most oce functions have specialized unit vocabularies and so
have little need of this function.
}
\examples{
as.unit("DBAR")
as.unit("IPTS-68")
as.unit("ITS-90")
as.unit("PSS-78")
as.unit("UMOL/KG")

}
\author{
Dan Kelley
}
