% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{read.oce}
\alias{read.oce}
\title{Read an Oceanographic Data File}
\usage{
read.oce(file, ..., encoding = "latin1")
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.}

\item{...}{arguments to be handed to whichever instrument-specific reading
function is selected, based on the header.}

\item{encoding}{a character string giving the file encoding.  This defaults
to \verb{"latin1}", which seems to work for files available to the authors, but
be aware that a different setting may be required for files that contain
unusual accents or characters.  (Try \code{"UTF-8"} if the default produces
errors.) Note that \code{encoding} is ignored in binary files, and also
in some text-based files, as well.}
}
\value{
An \linkS4class{oce} object of that is
specialized to the data type, e.g. \linkS4class{ctd},
if the data file contains \code{ctd} data.
}
\description{
Read an oceanographic data file, auto-discovering the file type from the
first line of the file.
This function tries to infer the file type from the first line, using
\code{\link[=oceMagic]{oceMagic()}}.  If it can be discovered, then an
instrument-specific file reading function is called, with the \code{file}
and with any additional arguments being supplied.
}
\examples{
library(oce)
x <- read.oce(system.file("extdata", "ctd.cnv", package="oce"))
plot(x) # summary with TS and profiles
plotTS(x) # just the TS
}
\seealso{
The file type is determined by \code{\link[=oceMagic]{oceMagic()}}.  If the file
type can be determined, then one of the following is called:
\code{\link[=read.ctd]{read.ctd()}}, \code{\link[=read.coastline]{read.coastline()}}
\code{\link[=read.lobo]{read.lobo()}}, \code{\link[=read.rsk]{read.rsk()}},
\code{\link[=read.sealevel]{read.sealevel()}}, etc.
}
\author{
Dan Kelley
}
