% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.R
\name{sunDeclinationRightAscension}
\alias{sunDeclinationRightAscension}
\title{Sun Declination and Right Ascension}
\usage{
sunDeclinationRightAscension(time, apparent = FALSE)
}
\arguments{
\item{time}{a POSIXct time. This ought to be in UTC timezone; if not,
the behaviour of this function is unlikely to be correct.}

\item{apparent}{logical value indicating whether to return
the 'apparent' angles.}
}
\value{
A list containing \code{declination} and \code{rightAscension}, in degrees.
}
\description{
The formulae are from Meeus (1991), chapter 24 (which uses chapter 21).
}
\examples{
## Example 24.a in Meeus (1991) (page 158 PDF, 153 print)
time <- as.POSIXct("1992-10-13 00:00:00", tz="UTC")
a <- sunDeclinationRightAscension(time, apparent=TRUE)
stopifnot(abs(a$declination - (-7.78507)) < 0.00004)
stopifnot(abs(a$rightAscension - (-161.61919)) < 0.00003)
b <- sunDeclinationRightAscension(time)
## check against previous results, to protect aginst code-drift errors
stopifnot(abs(b$declination - (-7.785464443)) < 0.000000001)
stopifnot(abs(b$rightAscension - (-161.6183305)) < 0.0000001)

}
\references{
\itemize{
\item Meeus, Jean. Astronomical Algorithms. Second Edition.
Richmond, Virginia, USA: Willmann-Bell, 1991.
}
}
\seealso{
Other things related to astronomy: 
\code{\link{angle2hms}()},
\code{\link{eclipticalToEquatorial}()},
\code{\link{equatorialToLocalHorizontal}()},
\code{\link{julianCenturyAnomaly}()},
\code{\link{julianDay}()},
\code{\link{moonAngle}()},
\code{\link{siderealTime}()},
\code{\link{sunAngle}()}
}
\author{
Dan Kelley, based on formulae in Meeus (1991).
}
\concept{things related to astronomy}
