% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windrose.R
\name{plot,windrose-method}
\alias{plot,windrose-method}
\alias{plot.windrose}
\title{Plot a windrose Object}
\usage{
\S4method{plot}{windrose}(
  x,
  type = c("count", "mean", "median", "fivenum"),
  convention = c("meteorological", "oceanographic"),
  mgp = getOption("oceMgp"),
  mar = c(mgp[1], mgp[1], 1 + mgp[1], mgp[1]),
  col,
  ...
)
}
\arguments{
\item{x}{a \linkS4class{windrose} object.}

\item{type}{The thing to be plotted, either the number of counts in the angle
interval, the mean of the values in the interval, the median of the values, or
a \code{\link[=fivenum]{fivenum()}} representation of the values.}

\item{convention}{String indicating whether to use meteorological convention or
oceanographic convention for the arrows that emanate from the centre of the
rose.  In meteorological convection, an arrow emanates towards the right on
the diagram if the wind is from the east; in oceanographic convention, such an
arrow indicates flow \emph{to} the east.}

\item{mgp}{Three-element numerical vector to use for \code{\link{par}}\code{(mgp)}, and also
for \code{\link{par}}\code{(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{Four-element numerical vector to be used with \code{\link{par}}\code{("mar")}.}

\item{col}{Optional list of colors to use.  If not set, the colors will be
\code{c("red", "pink", "blue", "lightgray")}.  For the first three types of
plot, the first color in this list is used to fill in the rose, the third is
used for the petals of the rose, and the fourth is used for grid lines. For the
\code{"fivenum"} type, the first color is used for the inter-quartile range,
the second is used outside this range, the third is used for the median, and
the fourth is, again, used for the grid lines.}

\item{...}{Optional arguments passed to plotting functions.}
}
\description{
Plot a \linkS4class{windrose} object.
}
\examples{
library(oce)
opar <- par(no.readonly = TRUE)
xcomp <- rnorm(360) + 1
ycomp <- rnorm(360)
wr <- as.windrose(xcomp, ycomp)
par(mfrow=c(1, 2))
plot(wr)
plot(wr, "fivenum")
par(opar)

}
\seealso{
Other functions that plot oce data: 
\code{\link{download.amsr}()},
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to windrose data: 
\code{\link{[[,windrose-method}},
\code{\link{[[<-,windrose-method}},
\code{\link{as.windrose}()},
\code{\link{summary,windrose-method}},
\code{\link{windrose-class}}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to windrose data}
