% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echosounder.R
\name{subset,echosounder-method}
\alias{subset,echosounder-method}
\title{Subset an Echosounder Object}
\usage{
\S4method{subset}{echosounder}(x, subset, ...)
}
\arguments{
\item{x}{an \linkS4class{echosounder} object.}

\item{subset}{a condition to be applied to the \code{data} portion of
\code{x}.  See \sQuote{Details}.}

\item{\dots}{ignored.}
}
\value{
An \linkS4class{echosounder} object.
}
\description{
This function is somewhat analogous to \code{\link[=subset.data.frame]{subset.data.frame()}}.
Subsetting can be by \code{time} or \code{depth}, but these may not be
combined; use a sequence of calls to subset by both.
}
\examples{
library(oce)
data(echosounder)
plot(echosounder)
plot(subset(echosounder, depth < 10))
plot(subset(echosounder, time < mean(range(echosounder[['time']]))))

}
\seealso{
Other things related to echosounder data: 
\code{\link{[[,echosounder-method}},
\code{\link{[[<-,echosounder-method}},
\code{\link{as.echosounder}()},
\code{\link{echosounder-class}},
\code{\link{echosounder}},
\code{\link{findBottom}()},
\code{\link{plot,echosounder-method}},
\code{\link{read.echosounder}()},
\code{\link{summary,echosounder-method}}

Other functions that subset oce objects: 
\code{\link{subset,adp-method}},
\code{\link{subset,adv-method}},
\code{\link{subset,amsr-method}},
\code{\link{subset,argo-method}},
\code{\link{subset,cm-method}},
\code{\link{subset,coastline-method}},
\code{\link{subset,ctd-method}},
\code{\link{subset,lobo-method}},
\code{\link{subset,met-method}},
\code{\link{subset,oce-method}},
\code{\link{subset,odf-method}},
\code{\link{subset,rsk-method}},
\code{\link{subset,sealevel-method}},
\code{\link{subset,section-method}},
\code{\link{subset,topo-method}},
\code{\link{subset,xbt-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to echosounder data}
