% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.nortek.R
\name{read.adp.nortek}
\alias{read.adp.nortek}
\title{Read a Nortek ADP File}
\usage{
read.adp.nortek(
  file,
  from = 1,
  to,
  by = 1,
  tz = getOption("oceTz"),
  longitude = NA,
  latitude = NA,
  type = c("aquadoppHR", "aquadoppProfiler", "aquadopp", "aquadoppPlusMagnetometer"),
  orientation,
  distance,
  monitor = FALSE,
  despike = FALSE,
  processingLog,
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.  (For \code{read.adp.sontek.serial}, this is generally a list of
files, which will be concatenated.)}

\item{from}{indication of the first profile to read.  This can be an
integer, the sequence number of the first profile to read, or a POSIXt time
before which profiles should be skipped, or a character string that converts
to a POSIXt time (assuming UTC timezone).  See \dQuote{Examples}, and make
careful note of the use of the \code{tz} argument. If \code{from} is not
supplied, it defaults to 1.}

\item{to}{an optional indication of the last profile to read, in a
format as described for \code{from}.  As a special case, \code{to=0} means
to read the file to the end.  If \code{to} is not supplied, then it defaults
to 0.}

\item{by}{an optional indication of the stride length to use while walking through
the file.  If this is an integer, then \code{by-1} profiles are skipped
between each pair of profiles that is read, e.g. the default \code{by=1}
means to read all the data.  (For RDI files \emph{only}, there are some
extra features to avoid running out of memory; see \dQuote{Memory considerations}.)}

\item{tz}{character string indicating time zone to be assumed in the data.}

\item{longitude}{optional signed number indicating the longitude in degrees
East.}

\item{latitude}{optional signed number indicating the latitude in degrees
North.}

\item{type}{a character string indicating the type of instrument.}

\item{orientation}{an optional character string specifying the orientation of
the sensor, provided for those cases in which it cannot be inferred from the
data file.  The valid choices are \code{"upward"}, \code{"downward"}, and
\code{"sideward"}.}

\item{distance}{an optional vector holding the distances of bin centres from
the sensor.  This argument is ignored except for Nortek profilers, and need
not be given if the function determines the distances correctly from the
data.  The problem is that the distance is poorly documented in the Nortek
System Integrator Guide (2008 edition, page 31), so the function must rely
on word-of-mouth formulae that do not work in all cases.}

\item{monitor}{boolean value indicating whether to indicate the progress
of reading the file, by using \code{\link[=txtProgressBar]{txtProgressBar()}} or otherwise.  The value
of \code{monitor} is changed to \code{FALSE} automatically, for non-interactive
sessions.}

\item{despike}{a logical value indicating whether to use \code{\link[=despike]{despike()}} to remove
anomalous spikes in heading, etc.}

\item{processingLog}{if provided, the action item to be stored in the log.
(Typically only provided for internal calls; the default that it provides is
better for normal calls by a user.)}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}

\item{\dots}{optional additional arguments that some (but not all)
\verb{read.adp.*()} functions pass to lower-level functions.}
}
\value{
An \linkS4class{adp} object.
The contents of that object make sense for the particular instrument
type under study, e.g. if the data file contains
NMEA strings, then navigational data will be stored in an item
called \code{nmea} in the \code{data} slot).
}
\description{
Read a Nortek ADP File
}
\references{
\enumerate{
\item Information on Nortek profilers (including the System Integrator Guide,
which explains the data format byte-by-byte) is available at
\url{https://www.nortekusa.com/}.  (One must join the site to see the
manuals.)
\item The Nortek Knowledge Center
\url{https://www.nortekusa.com/en/knowledge-center} may be of help if
problems arise in dealing with data from Nortek instruments.
}
}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpEnsembleAverage}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Dan Kelley
}
\concept{things related to adp data}
