% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceColorsGebco}
\alias{oceColorsGebco}
\alias{oce.colorsGebco}
\title{Create colors in a Gebco-like scheme}
\usage{
oceColorsGebco(
  n = 9,
  region = c("water", "land", "both"),
  type = c("fill", "line")
)
}
\arguments{
\item{n}{Number of colors to return}

\item{region}{String indicating application region, one of \code{"water"}, \code{"land"},
or \code{"both"}.}

\item{type}{String indicating the purpose, one of \code{"fill"} or \code{"line"}.}
}
\description{
Create colors in a Gebco-like scheme
}
\examples{
library(oce)
imagep(min(volcano) - volcano, col=oceColorsGebco(128),
       zlab="oceColorsGebco")
}
\seealso{
Other things related to colors: 
\code{\link{colormap}()},
\code{\link{oceColors9B}()},
\code{\link{oceColorsCDOM}()},
\code{\link{oceColorsChlorophyll}()},
\code{\link{oceColorsClosure}()},
\code{\link{oceColorsDensity}()},
\code{\link{oceColorsFreesurface}()},
\code{\link{oceColorsJet}()},
\code{\link{oceColorsOxygen}()},
\code{\link{oceColorsPAR}()},
\code{\link{oceColorsPalette}()},
\code{\link{oceColorsPhase}()},
\code{\link{oceColorsSalinity}()},
\code{\link{oceColorsTemperature}()},
\code{\link{oceColorsTurbidity}()},
\code{\link{oceColorsTwo}()},
\code{\link{oceColorsVelocity}()},
\code{\link{oceColorsViridis}()},
\code{\link{oceColorsVorticity}()},
\code{\link{ocecolors}}

Other things related to colors: 
\code{\link{colormap}()},
\code{\link{oceColors9B}()},
\code{\link{oceColorsCDOM}()},
\code{\link{oceColorsChlorophyll}()},
\code{\link{oceColorsClosure}()},
\code{\link{oceColorsDensity}()},
\code{\link{oceColorsFreesurface}()},
\code{\link{oceColorsJet}()},
\code{\link{oceColorsOxygen}()},
\code{\link{oceColorsPAR}()},
\code{\link{oceColorsPalette}()},
\code{\link{oceColorsPhase}()},
\code{\link{oceColorsSalinity}()},
\code{\link{oceColorsTemperature}()},
\code{\link{oceColorsTurbidity}()},
\code{\link{oceColorsTwo}()},
\code{\link{oceColorsVelocity}()},
\code{\link{oceColorsViridis}()},
\code{\link{oceColorsVorticity}()},
\code{\link{ocecolors}}
}
\concept{things related to colors}
