% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{plotScan}
\alias{plotScan}
\title{Plot CTD data in a Low-Level Fashion}
\usage{
plotScan(x, which = 1, xtype = "scan", type = "l",
  mgp = getOption("oceMgp"), mar = c(mgp[1] + 1.5, mgp[1] + 1.5, mgp[1],
  mgp[1]), ...)
}
\arguments{
\item{x}{A \code{ctd} object, i.e. one inheriting from \code{\link{ctd-class}}.}

\item{which}{Numerical vector numerical codes specifying the panels to draw: 1
for pressure vs scan, 2 for \code{diff(pressure)} vs scan, 3 for temperature vs
scan, and 4 for salinity vs scan.}

\item{xtype}{Character string indicating variable for the x axis. May be
\code{"scan"} (the default) or \code{"time"}. In the former case, a
\code{scan} variable will be created using \code{\link{seq_along}},
if necessary. In the latter case, an error results if the \code{data}
slot of \code{x} lacks a variable called \code{time}.}

\item{type}{Line type.}

\item{mgp}{Three-element numerical vector to use for \code{par(mgp)}, and also
for \code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{Four-element vector be used with \code{\link{par}("mar")}.  If set
to \code{NULL}, then \code{par("mar")} is used.  A good choice for a TS diagram
with a palette to the right is \code{mar=par("mar")+c(0, 0, 0, 1))}.}

\item{...}{Optional arguments passed to plotting functions.}
}
\description{
Plot CTD data as time-series against scan number, to help with trimming
extraneous data from a CTD cast.
}
\examples{
library(oce)
data(ctdRaw) 
plotScan(ctdRaw)
abline(v=c(130, 350), col='red') # useful for ctdTrim()

}
\author{
Dan Kelley
}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotTS}},
  \code{\link{tidem-class}}

Other things related to \code{ctd} data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdAddColumn}}, \code{\link{ctdDecimate}},
  \code{\link{ctdFindProfiles}}, \code{\link{ctdRaw}},
  \code{\link{ctdTrim}}, \code{\link{ctdUpdateHeader}},
  \code{\link{ctd}}, \code{\link{gps-class}},
  \code{\link{handleFlags,ctd-method}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotTS}}, \code{\link{read.ctd.itp}},
  \code{\link{read.ctd.odf}}, \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{subset,ctd-method}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}}, \code{\link{write.ctd}}
}

