% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oce.grid}
\alias{oce.grid}
\title{Add a Grid to an Existing Oce Plot}
\usage{
oce.grid(xat, yat, col = "lightgray", lty = "dotted", lwd = par("lwd"))
}
\arguments{
\item{xat}{either a list of x values at which to draw the grid, or the return value from an oce plotting function}

\item{yat}{a list of y values at which to plot the grid (ignored if \code{gx} was a return value from an oce plotting function)}

\item{col}{colour of grid lines (see \code{\link{par}})}

\item{lty}{type for grid lines (see \code{\link{par}})}

\item{lwd}{width for grid lines (see \code{\link{par}})}
}
\description{
Add a Grid to an Existing Oce Plot
}
\details{
For plots not created by oce functions, or for missing \code{xat} and \code{yat},
this is the same as a call to \code{\link{grid}} with missing \code{nx} and
\code{ny}. However, if \code{xat} is the return value from certain oce functions,
a more sophisticated grid is constructed. The problem with \code{\link{grid}} is
that it cannot handle axes with non-uniform grids, e.g. those with time axes
that span months of differing lengths.

As of early February 2015, \code{oce.grid} handles \code{xat} produced as the
return value from the following functions: \code{\link{imagep}} and
\code{\link{oce.plot.ts}}, \code{\link{plot,adp-method}},
\code{\link{plot,echosounder-method}}, and \code{\link{plotTS}}.
It makes no sense to try to use \code{oce.grid} for multiplanel oce plots,
e.g. the default plot from \code{\link{plot,adp-method}}.
}
\examples{
library(oce)
i <- imagep(volcano)
oce.grid(i, lwd=2)

data(sealevel)
i <- oce.plot.ts(sealevel[["time"]], sealevel[["elevation"]])
oce.grid(i, col='red')

data(ctd)
i <- plotTS(ctd)
oce.grid(i, col='red')

data(adp)
i <- plot(adp, which=1)
oce.grid(i, col='gray', lty=1)

data(echosounder)
i <- plot(echosounder)
oce.grid(i, col='pink', lty=1)

}

