% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{envOutliers}
\alias{envOutliers}
\title{Detect environmental outliers}
\usage{
envOutliers(
  df,
  xf,
  yf,
  .r.env,
  .th.perc.outenv,
  .sp.name,
  method = "all",
  .projString,
  do = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{df}{data.frame of species occurrences}

\item{xf}{character. column name in df containing the x coordinates}

\item{yf}{character. column name in df containing the y coordinates}

\item{.r.env}{raster. Raster with environmental data}

\item{.th.perc.outenv}{numeric. Value from 0 to 1 to identify the rate of variables not passing the test to consider the record an environmental outlier.}

\item{.sp.name}{Species name}

\item{method}{charcter. Vector of methods to be used. See details. Default 'all'}

\item{.projString}{proj4string character. Indicate coordinate reference system}

\item{do}{logical. Should tests be performed? Default TRUE}

\item{verbose}{logical. Print messages? Default FALSE}
}
\value{
data.frame
}
\description{
Detect environmental outliers using different methods
}
\details{
Implemented methods are :\cr
'bxp' based on boxplot distribution (1.5 Interquartile range) in a variable to identify the record as outlier (\link[biogeo]{outliers}) \cr
'Grubbs' based on Grubbs test. See ?findEnvOutliers \cr
Regardless of the method, the function already tests for missing environmental variables and it outputs the result in the output data.frame
}
\seealso{
findEnvOutliers \link[biogeo]{outliers}
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr), Cory Merow (cmerow@gmail.com). Mark Robertson (biogeo package)
}
\keyword{internal}
