% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_fine-tunes.R
\name{fine_tunes_list_request}
\alias{fine_tunes_list_request}
\title{API fine tunes: list request}
\usage{
fine_tunes_list_request(api_key)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see \url{https://platform.openai.com/account/api-keys})}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
\url{https://platform.openai.com/docs/api-reference/fine-tunes/list}
}
\examples{
\dontrun{
res_content <- fine_tunes_list_request("my-secret-api-key-string")
if (!is_error(res_content)) {
  fine_tunes_list_df <- fine_tunes_fetch_list(res_content)
  print(fine_tunes_list_df)
}
}

}
