% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_midterm_predictions}
\alias{example_midterm_predictions}
\title{Example Midterm Predictions Data}
\format{
A data frame with 1,825 rows and 46 columns:
\describe{
\item{\code{country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{date}}{The date (in \code{YYYY-MM-DD} format).}
\item{\code{year}}{The respective year.}
\item{\code{month}}{The respective month.}
\item{\code{day}}{The respective day.}
\item{\code{wday}}{The type of weekday (e.g., \code{Sun}, \code{Mon})}
\item{\code{avg_hourly_demand}}{The average hourly electricity demand (in megawatts) for the day.}
\item{\code{seasonal_avg_hourly_demand}}{The seasonal average hourly demand (in megawatts) for the day.}
\item{\code{holiday}}{Indicates whether the day is a public holiday (\code{1} for holiday, \code{0} for non-holiday).}
\item{\code{weighted_temperature}}{The weighted average temperature for France on that day (in degrees Celsius).}
\item{\code{Jan}, \code{Feb}, \code{Mar}, \code{Apr}, \code{May}, \code{Jun}, \code{Jul}, \code{Aug}, \code{Sep}, \code{Nov}, \code{Dec}}{Monthly dummy variables for January through December, indicating the respective month (\code{1} if the date belongs to the month, \code{0} otherwise).}
\item{\code{Sun}, \code{Mon}, \code{Tue}, \code{Wed}, \code{Thu}, \code{Fri}, \code{Sat}}{Weekly dummy variables for Sunday through Saturday, indicating the respective weekday (\code{1} if the date is the specific weekday, \code{0} otherwise).}
\item{\code{HD}}{The weighted temperature converted to heating degree days.}
\item{\code{CD}}{The weighted temperature converted to cooling degree days.}
\item{\code{HD2}}{The squared heating degree days (HD).}
\item{\code{HD3}}{The cubed heating degree days (HD).}
\item{\code{CD2}}{The squared cooling degree days (CD).}
\item{\code{CD3}}{The cubed cooling degree days (CD).}
\item{\code{weighted_temperature2}}{The squared weighted temperature.}
\item{\code{weighted_temperature3}}{The cubed weighted temperature.}
\item{\code{HDlag1}}{Lagged value of heating degree days (1 day).}
\item{\code{HDlag2}}{Lagged value of heating degree days (2 days).}
\item{\code{CDlag1}}{Lagged value of cooling degree days (1 day).}
\item{\code{CDlag2}}{Lagged value of cooling degree days (2 days).}
\item{\code{weighted_temperaturelag1}}{Lagged weighted temperature (1 day).}
\item{\code{weighted_temperaturelag2}}{Lagged weighted temperature (2 days).}
\item{\code{midterm_model_fit}}{model predictions for the seasonal mid-term component.}
\item{\code{end_of_year}}{Binary dummy variable to account for lower demand between Christmas and New Year's Evening. Starts at 22nd December.}
\item{\code{test_set_steps}}{Number of days used in the test set for model evaluation.}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
}
\source{
demand data: Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/);
holidays: https://date.nager.at/api/v3/publicholidays/ ; area population: https://wft-geo-db.p.rapidapi.com ; daily average temperatures: https://meteostat.p.rapidapi.com;
}
\usage{
example_midterm_predictions
}
\description{
This dataset extends the \code{demand} dataframe from \code{\link{example_midterm_demand_and_weather_data}} with the prediction results from the best derived mid-term seasonality model.
It also includes all used covariates for the model selection process.
}
\keyword{dataset}
\keyword{midterm}
\keyword{prediction}
