% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_rotate_2d.R
\name{pca_rotate_2d}
\alias{pca_rotate_2d}
\title{Manually rotate two PCs around the origin}
\usage{
pca_rotate_2d(pca_obj, angle, pcs = c(1, 2))
}
\arguments{
\item{pca_obj}{The result of a call to \code{prcomp()} or \code{princomp()}. \strong{NB} It
does not make sense to apply this function to the output of \code{pca_test}.}

\item{angle}{A number indicating the number of degrees to rotate around the
origin clockwise. Negative values will rotated counterclockwise.}

\item{pcs}{A two-element vector identifying the two PCs to rotate.}
}
\value{
An object matching the class of \code{pca_obj} with loadings, scores, and
variance explained by each component modified.
}
\description{
It is sometimes convenient to rotate principal components to most closely
align with a sensible interpretation in terms of the original variables or
to compare the results of PCA applied to two distinct datasets. This function
allows for manual 2D rotations of principal components.
}
\details{
\strong{NB: rotated components are not principal components.} They no longer explain
maximal variance. Rotated components should not be referred to as 'principal
components'. The simplest approach is just to call them 'components' after
describing the rotation. This function modifies objects of the class 'prcomp'
and 'princomp', adding an additional 'note' which collects all the rotations
which have been applied. This allows any plotting function which works with
the outputs of \code{prcomp()} or \code{princomp()} to work. This may result in plots
which incorrectly identify rotated components as principal components. Be
careful not to include any such plot in a research output.
}
\examples{
  pca_obj <- prcomp(onze_intercepts |> dplyr::select(-speaker), scale=TRUE)

  # Rotate PCs 3 and 6 by 10 degrees.
  rotated_pca <- pca_rotate_2d(pca_obj, 10, pcs = c(3,6))
}
