% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_and_seats.R
\name{allocate_seats}
\alias{allocate_seats}
\title{Allocate seats after election}
\usage{
allocate_seats(votes, parties = names(votes), nseats = 120,
  threshold = 0.05, electorate = rep(0, length(votes)))
}
\arguments{
\item{votes}{vector of vote proportions or counts.}

\item{parties}{vector of names of parties.}

\item{nseats}{number of seats to allocate.  Note that in mixed systems such as New Zealand's
where \code{electorate} is not all zero, there may be a "hangover" and total number of seats
ends up larger than \code{nseats} due to parties that win an electorate seat but received less
than \code{1/nseats} of the vote.}

\item{threshold}{minimum proportion of votes needed to be allocated a seat.}

\item{electorate}{a numeric vector of same length as parties, for use in mixed-member
proportional systems such as New Zealand's.  If the ith \code{electorate > 0},
the ith party is allocated seats regardless of whether the party exceeded \code{threshold}.
This is needed in a mixed-member proportional system such as New Zealand's.}
}
\value{
A list with two elements: a data frame \code{seats_df} and a vector
\code{seats_v}, each of which provides information on the number of seats 
allocated to each party.

The data frame has four columns: \code{proportionally_allocated}, 
\code{electorate_seats}, \code{final} and \code{party}.  In New Zealand, the number of
"list MPs" for each party is \code{final - electorate_seats}.

The vector is the same as \code{final} in the data frame, with names equal to \code{party}.
}
\description{
Allocates seats in Parliament after an election using the Sainte-Lague 
allocation formula
}
\examples{

# From Wikipedia; should return 3, 2, 2:
allocate_seats(c(53000, 24000, 23000), nseats = 7, threshold = 0)

# From 2014 New Zealand election
votes <- c(National = 1131501, Labour = 604535, Green = 257359,
           NZFirst = 208300, Cons = 95598, IntMana = 34094, 
           Maori = 31849, Act = 16689, United = 5286,
           Other = 20411)
electorate = c(41, 27, 0, 
               0, 0, 0, 
               1, 1, 1,
               0)
               
# Actual result:               
allocate_seats(votes, electorate = electorate)

# Result if there were no 5\% minimum threshold:
allocate_seats(votes, electorate = electorate, threshold = 0)$seats_v
}
\references{
\url{http://www.elections.org.nz/voting-system/mmp-voting-system/sainte-lague-allocation-formula}   

See also Wikipedia on the Webster/Sainte-Lague method.
}
\author{
Peter Ellis
}
