% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_servingsize}
\alias{get_servingsize}
\title{get_servingsize}
\usage{
get_servingsize(apiKey = NULL, foodCode = NULL, lang = "en")
}
\arguments{
\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientamount}.
If none is provided, the system environment variables will be checked.}

\item{foodCode}{The code indicating the food you want to search for. If null,
all foods and their corresponding serving sizes are returned.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing conversion factor values, food names, food codes and serving sizes.
}
\description{
Makes a query to the Canadian Nutrient File servingsize endpoint. This endpoint returns
a list of serving sizes as well as the corresponding food code and description. The conversion
factor value is also given. This represents the proportion of weight between cooked edible
portion and raw edible portion.
\href{https://www.researchgate.net/publication/327790633_Cooking_conversion_factor_of_commonly_consumed_Sri_Lankan_food_items#:~:text=Conversion\%20factor\%20is\%20the\%20proportion,water\%20reduction\%20and\%20fat\%20absorption.}{conversion factor}
}
\examples{
\dontrun{
get_servingsize()
get_servingsize(foodCode = 45)
get_servingsize(foodCode = 45, lang = "fr")}
}
