% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_nutrientgroup}
\alias{get_nutrientgroup}
\title{get_nutrientgroup}
\usage{
get_nutrientgroup(apiKey = NULL, nutrientGroupId = NULL, lang = "en")
}
\arguments{
\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientgroup}.
If none is provided, the system environment variables will be checked.}

\item{nutrientGroupId}{The code indicating the nutrient group you want to search for. If null,
all foods and their corresponding names are returned.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing nutrient group's id, name, order
}
\description{
Makes a query to the Canadian Nutrient File refuseamount endpoint. This endpoint
returns a list of all nutrient group ids and their names. For instance,
if nutrient group id is mentioned as 5, the corressponding group name is amino acids
}
\examples{
\dontrun{
get_nutrientgroup()
get_nutrientgroup(nutrientGroupId = 7)
get_nutrientgroup(nutrientGroupId = 7, lang = "fr")}
}
