% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_year.R
\name{f_year}
\alias{f_year}
\alias{f_year.numeric}
\alias{f_year.Date}
\alias{f_year.POSIXlt}
\title{Format Years}
\usage{
f_year(x, digits = 2, ...)

\method{f_year}{numeric}(x, digits = 2, ...)

\method{f_year}{Date}(x, digits = 2, ...)

\method{f_year}{POSIXlt}(x, digits = 2, ...)
}
\arguments{
\item{x}{A vector of 4 digits integers, dates, or POSIXlt.}

\item{digits}{Either 2 or 4 for the number of digits to make the year.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector of two or four digit years.
}
\description{
Format 4 digit integer, date, or POSIXlt formats to 2 or 4 digit years.
}
\examples{
f_year(as.Date(paste0(1998:2016, '-12-12')))
f_year(c(NA, 1998:2016, 21345))
}
