% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_common_diploid}
\alias{find_common_diploid}
\title{Find the common diploid region in a group of pseudobulks}
\usage{
find_common_diploid(
  bulks,
  grouping = "clique",
  gamma = 20,
  theta_min = 0.08,
  t = 1e-05,
  fc_min = 2^0.25,
  alpha = 1e-04,
  min_genes = 10,
  ncores = 1,
  segs_loh = NULL,
  debug = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{bulks}{dataframe Pseudobulk profiles (differentiated by "sample" column)}

\item{grouping}{logical Whether to use cliques or components in the graph to find dipoid cluster}

\item{gamma}{numeric Dispersion parameter for the Beta-Binomial allele model}

\item{theta_min}{numeric Minimum imbalance threshold}

\item{t}{numeric Transition probability}

\item{fc_min}{numeric Minimum fold change to call quadruploid cluster}

\item{alpha}{numeric FDR cut-off for q values to determine edges}

\item{ncores}{integer Number of cores to use}
}
\value{
list Ploidy information
}
\description{
Find the common diploid region in a group of pseudobulks
}
\keyword{internal}
