% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{Numbat}
\alias{Numbat}
\title{Numbat R6 class}
\value{
a new 'Numbat' object
}
\description{
Used to allow users to plot results
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{label}}{character Sample name}

\item{\code{gtf}}{dataframe Transcript annotation}

\item{\code{joint_post}}{dataframe Joint posterior}

\item{\code{exp_post}}{dataframe Expression posterior}

\item{\code{allele_post}}{dataframe Allele posetrior}

\item{\code{bulk_subtrees}}{dataframe Bulk profiles of lineage subtrees}

\item{\code{bulk_clones}}{dataframe Bulk profiles of clones}

\item{\code{segs_consensus}}{dataframe Consensus segments}

\item{\code{tree_post}}{list Tree posterior}

\item{\code{mut_graph}}{igraph Mutation history graph}

\item{\code{gtree}}{tbl_graph Single-cell phylogeny}

\item{\code{clone_post}}{dataframe Clone posteriors}

\item{\code{gexp_roll_wide}}{matrix Smoothed expression of single cells}

\item{\code{hc}}{hclust Initial hierarchical clustering}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Numbat-new}{\code{Numbat$new()}}
\item \href{#method-Numbat-plot_phylo_heatmap}{\code{Numbat$plot_phylo_heatmap()}}
\item \href{#method-Numbat-plot_exp_roll}{\code{Numbat$plot_exp_roll()}}
\item \href{#method-Numbat-plot_mut_history}{\code{Numbat$plot_mut_history()}}
\item \href{#method-Numbat-plot_sc_tree}{\code{Numbat$plot_sc_tree()}}
\item \href{#method-Numbat-plot_consensus}{\code{Numbat$plot_consensus()}}
\item \href{#method-Numbat-plot_clone_profile}{\code{Numbat$plot_clone_profile()}}
\item \href{#method-Numbat-clone}{\code{Numbat$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Numbat-new"></a>}}
\if{latex}{\out{\hypertarget{method-Numbat-new}{}}}
\subsection{Method \code{new()}}{
initialize Numbat class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Numbat$new(out_dir, i = 2, gtf = gtf_hg38, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{out_dir}}{character string Output directory}

\item{\code{i}}{integer Get results from which iteration (either 1 or 2) (default=2)}

\item{\code{gtf}}{dataframe Transcript gtf (default=gtf_hg38)}

\item{\code{verbose}}{logical Whether to output verbose results (default=TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new 'Numbat' object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Numbat-plot_phylo_heatmap"></a>}}
\if{latex}{\out{\hypertarget{method-Numbat-plot_phylo_heatmap}{}}}
\subsection{Method \code{plot_phylo_heatmap()}}{
Plot the single-cell CNV calls in a heatmap and the corresponding phylogeny
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Numbat$plot_phylo_heatmap(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{additional parameters passed to plot_phylo_heatmap()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Numbat-plot_exp_roll"></a>}}
\if{latex}{\out{\hypertarget{method-Numbat-plot_exp_roll}{}}}
\subsection{Method \code{plot_exp_roll()}}{
Plot window-smoothed expression profiles
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Numbat$plot_exp_roll(k = 3, n_sample = 300, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{integer Number of clusters}

\item{\code{n_sample}}{integer Number of cells to subsample}

\item{\code{...}}{additional parameters passed to plot_exp_roll()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Numbat-plot_mut_history"></a>}}
\if{latex}{\out{\hypertarget{method-Numbat-plot_mut_history}{}}}
\subsection{Method \code{plot_mut_history()}}{
Plot the mutation history of the tumor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Numbat$plot_mut_history(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{additional parameters passed to plot_mut_history()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Numbat-plot_sc_tree"></a>}}
\if{latex}{\out{\hypertarget{method-Numbat-plot_sc_tree}{}}}
\subsection{Method \code{plot_sc_tree()}}{
Plot the single cell phylogeny
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Numbat$plot_sc_tree(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{additional parameters passed to plot_sc_tree()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Numbat-plot_consensus"></a>}}
\if{latex}{\out{\hypertarget{method-Numbat-plot_consensus}{}}}
\subsection{Method \code{plot_consensus()}}{
Plot consensus segments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Numbat$plot_consensus(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{additional parameters passed to plot_sc_tree()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Numbat-plot_clone_profile"></a>}}
\if{latex}{\out{\hypertarget{method-Numbat-plot_clone_profile}{}}}
\subsection{Method \code{plot_clone_profile()}}{
Plot clone cnv profiles
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Numbat$plot_clone_profile(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{additional parameters passed to plot_clone_profile()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Numbat-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Numbat-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Numbat$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
