% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig_complement_contrasts.R
\name{dig_complement_contrasts}
\alias{dig_complement_contrasts}
\title{Search for conditions that provide significant differences in selected
variables to the rest of the data table}
\usage{
dig_complement_contrasts(
  x,
  condition = where(is.logical),
  vars = where(is.numeric),
  disjoint = var_names(colnames(x)),
  excluded = NULL,
  min_length = 0L,
  max_length = Inf,
  min_support = 0,
  max_support = 1 - min_support,
  method = "t",
  alternative = "two.sided",
  h0 = if (method == "var") 1 else 0,
  conf_level = 0.95,
  max_p_value = 0.05,
  t_var_equal = FALSE,
  wilcox_exact = FALSE,
  wilcox_correct = TRUE,
  wilcox_tol_root = 1e-04,
  wilcox_digits_rank = Inf,
  max_results = Inf,
  verbose = FALSE,
  threads = 1L
)
}
\arguments{
\item{x}{a matrix or data frame with data to search the patterns in.}

\item{condition}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as condition predicates}

\item{vars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use for computation of contrasts}

\item{disjoint}{an atomic vector of size equal to the number of columns of \code{x}
that specifies the groups of predicates: if some elements of the \code{disjoint}
vector are equal, then the corresponding columns of \code{x} will NOT be
present together in a single condition. If \code{x} is prepared with
\code{\link[=partition]{partition()}}, using the \code{\link[=var_names]{var_names()}} function on \code{x}'s column names
is a convenient way to create the \code{disjoint} vector.}

\item{excluded}{NULL or a list of character vectors, where each character vector
contains the names of columns that must not appear together in a single
condition.}

\item{min_length}{the minimum size (the minimum number of predicates) of the
condition to be generated (must be greater or equal to 0). If 0, the
empty condition is generated in the first place.}

\item{max_length}{The maximum size (the maximum number of predicates) of the
condition to be generated. If equal to Inf, the maximum length of
conditions is limited only by the number of available predicates.}

\item{min_support}{the minimum support of a condition to trigger the callback
function for it. The support of the condition is the relative frequency
of the condition in the dataset \code{x}. For logical data, it equals to the
relative frequency of rows such that all condition predicates are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{max_support}{the maximum support of a condition to trigger the callback
function for it. See argument \code{min_support} for details of what is the
support of a condition.}

\item{method}{a character string indicating which contrast to compute.
One of \code{"t"}, for parametric, or \code{"wilcox"}, for non-parametric test on
equality in position, and \code{"var"} for F-test on comparison of variances
of two populations.}

\item{alternative}{indicates the alternative hypothesis and must be one of
\code{"two.sided"}, \code{"greater"} or \code{"less"}. \code{"greater"} corresponds to
positive association, \code{"less"} to negative association.}

\item{h0}{a numeric value specifying the null hypothesis for the test. For
the \code{"t"} method, it is the difference in means. For the \code{"wilcox"} method,
it is the difference in medians. For the \code{"var"} method, it is the
hypothesized ratio of the population variances. The default value is 1
for \code{"var"} method, and 0 otherwise.}

\item{conf_level}{a numeric value specifying the level of the confidence
interval. The default value is 0.95.}

\item{max_p_value}{the maximum p-value of a test for the pattern to be considered
significant. If the p-value of the test is greater than \code{max_p_value}, the
pattern is not included in the result.}

\item{t_var_equal}{(used for the \code{"t"} method only) a logical value indicating
whether the variances of the two samples are assumed to be equal. If
\code{TRUE}, the pooled variance is used to estimate the variance in the t-test.
If \code{FALSE}, the Welch (or Satterthwaite) approximation to the degrees of
freedom is used. See \code{\link[=t.test]{t.test()}} and its \code{var.equal} argument for more
information.}

\item{wilcox_exact}{(used for the \code{"wilcox"} method only) a logical value
indicating whether the exact p-value should be computed. If \code{NULL}, the
exact p-value is computed for sample sizes less than 50. See \code{\link[=wilcox.test]{wilcox.test()}}
and its \code{exact} argument for more information. Contrary to the behavior
of \code{\link[=wilcox.test]{wilcox.test()}}, the default value is \code{FALSE}.}

\item{wilcox_correct}{(used for the \code{"wilcox"} method only) a logical value
indicating whether the continuity correction should be applied in the
normal approximation for the p-value, if \code{wilcox_exact} is \code{FALSE}. See
\code{\link[=wilcox.test]{wilcox.test()}} and its \code{correct} argument for more information.}

\item{wilcox_tol_root}{(used for the \code{"wilcox"} method only) a numeric value
specifying the tolerance for the root-finding algorithm used to compute
the exact p-value. See \code{\link[=wilcox.test]{wilcox.test()}} and its \code{tol.root} argument for
more information.}

\item{wilcox_digits_rank}{(used for the \code{"wilcox"} method only) a numeric value
specifying the number of digits to round the ranks to. See \code{\link[=wilcox.test]{wilcox.test()}}
and its \code{digits.rank} argument for more information.}

\item{max_results}{the maximum number of generated conditions to execute the
callback function on. If the number of found conditions exceeds
\code{max_results}, the function stops generating new conditions and returns
the results. To avoid long computations during the search, it is recommended
to set \code{max_results} to a reasonable positive value. Setting \code{max_results}
to \code{Inf} will generate all possible conditions.}

\item{verbose}{a logical scalar indicating whether to print progress messages.}

\item{threads}{the number of threads to use for parallel computation.}
}
\value{
An S3 object which is an instance of \code{complement_contrasts} and \code{nugget}
classes and which is a tibble with found patterns in rows. The following
columns are always present:
\item{condition}{the condition of the pattern as a character string
in the form \code{{p1 & p2 & ... & pn}} where \code{p1}, \code{p2}, ..., \code{pn} are
\code{x}'s column names.}
\item{support}{the support of the condition, i.e., the relative
frequency of the condition in the dataset \code{x}.}
\item{var}{the name of the contrast variable.}
\item{estimate}{the estimate value (see the underlying test.}
\item{statistic}{the statistic of the selected test.}
\item{p_value}{the p-value of the underlying test.}
\item{n_x}{the number of rows in the sub-data corresponding to
the condition.}
\item{n_y}{the number of rows in the sub-data corresponding to
the negation of the condition.}
\item{conf_int_lo}{the lower bound of the confidence interval of the estimate.}
\item{conf_int_hi}{the upper bound of the confidence interval of the estimate.}
\item{alternative}{a character string indicating the alternative
hypothesis. The value must be one of \code{"two.sided"}, \code{"greater"}, or
\code{"less"}.}
\item{method}{a character string indicating the method used for the
test.}
\item{comment}{a character string with additional information about the
test (mainly error messages on failure).}
For the \code{"t"} method, the following additional columns are also
present (see also \code{\link[=t.test]{t.test()}}):
\item{df}{the degrees of freedom of the t test.}
\item{stderr}{the standard error of the mean difference.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Complement contrast patterns identify conditions under which there is
a significant difference in some numerical variable between elements
that satisfy the identified condition and the rest of the data table.

\describe{
\item{Scheme:}{\verb{(var | C) != (var | not C)}\cr\cr
There is a statistically significant difference in variable \code{var} between
group of elements that satisfy condition \code{C} and a group of elements that
do not satisfy condition \code{C}.}
\item{Example:}{\code{(life_expectancy | smoker) < (life_expectancy | non-smoker)}\cr\cr
The life expectancy in people that smoke cigarettes is in average
significantly lower than in people that do not smoke.}
}

The complement contrast is computed using a two-sample statistical test,
which is specified by the \code{method} argument. The function computes the
complement contrast in all variables specified by the \code{vars} argument.
Complement contrasts are computed based on sub-data corresponding
to conditions generated from the \code{condition} columns and the rest of the
data table. Function #' \code{dig_complement_contrasts()} supports crisp
conditions only, i.e., the condition columns in \code{x} must be logical.
}
\seealso{
\code{\link[=dig_baseline_contrasts]{dig_baseline_contrasts()}}, \code{\link[=dig_paired_baseline_contrasts]{dig_paired_baseline_contrasts()}},
\code{\link[=dig]{dig()}}, \code{\link[=dig_grid]{dig_grid()}},
\code{\link[stats:t.test]{stats::t.test()}}, \code{\link[stats:wilcox.test]{stats::wilcox.test()}}, \code{\link[stats:var.test]{stats::var.test()}}
}
\author{
Michal Burda
}
