#  Copyright 2013 Christian Sigg
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  http://www.r-project.org/Licenses/

#' Cardinality of Column Vectors
#' 
#' Computes the cardinality (the sum of non-zero elements) of each column of 
#' the matrix \eqn{\mathbf{W}}{W}.
#' 
#' @export
#' @param W a numeric matrix, e.g. the rotation matrix of a sparse PCA analysis
cardinality <- function(W) {
    return(colSums(abs(as.matrix(W)) > 0))
}