% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-stock.R
\name{nse_stock_most_traded}
\alias{nse_stock_most_traded}
\title{Most actively traded stocks}
\usage{
nse_stock_most_traded(clean_names = TRUE)
}
\arguments{
\item{clean_names}{Logical; if \code{TRUE}, makes the column names
descriptive and uses snake_case.}
}
\value{
A tibble with the following columns:

\item{security}{Name of the firm.}
\item{share_turnover}{Share in total turnover (percentage).}
\item{traded_quantity}{Total traded quantity (in lakhs)}
\item{no_of_trades}{Number of trades.}
\item{avg_daily_turnover}{Average daily turnover (in crores).}
\item{turnover}{Turnover (in crores.)}
}
\description{
Fetch most actively traded stocks in a month on NSE.
}
\examples{
\dontrun{
nse_stock_most_traded()

# retain original column names as returned by NSE
nse_stock_most_traded(clean_names = FALSE)
}

}
