% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{gcv}
\alias{gcv}
\title{gcv}
\usage{
gcv(x,y,eps,which,ytype,complex.x,complex.y)
}
\arguments{
\item{x}{input predictor matrix from training set}

\item{y}{response variables}

\item{eps}{candidate}

\item{which}{choose between ex and ey}

\item{ytype}{type of response variables}

\item{complex.x}{tuning parameter for the Gaussian kernel in X}

\item{complex.y}{tuning parameter for the Gaussian kernel in Y}
}
\value{
gcv criterion
}
\description{
gcv
}
\examples{
n = 50; p = 5; sigma = 1;
x = matrix(rnorm(n*p),n,p) ; err = rnorm(n)
y = (x[,1]+1)^2 + sigma*err; ex=0.01 ; ey=0.01; candidate=0.01
epsx <- gcv(x,y,candidate,"ex", "categorical",1,1)
epsy <- gcv(x,y,candidate,"ey", "categorical",1,1)
}
\references{
Li, B. (2018). Sufficient dimension reduction: Methods and applications with R. CRC Press.
}
