% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_and_or_list.R
\name{get_and_or_list}
\alias{get_and_or_list}
\title{Returns a one element character string with correct punctuation for
a list made up of the elements of the character vector argument.}
\usage{
get_and_or_list(c_vector, conjunction = "and")
}
\arguments{
\item{c_vector}{Character vector containing the list of words
to be put in a list.}

\item{conjunction}{The conjunction to be used as the connector.
This is usually `and' or `or' with `and' being the default.}
}
\value{
A character vector of length one containing the a single correctly
punctuated character string that list each element in the first arguments
vector with commas between if there are more than two elements with the
last two elements joined by the selected conjunction.
}
\description{
Returns a one element character string with correct punctuation for
a list made up of the elements of the character vector argument.
}
\examples{
\donttest{
get_and_or_list(c("Bob", "John")) # "Bob and John"
get_and_or_list(c("Bob", "John"), "or") # "Bob or John"
get_and_or_list(c("Bob", "John", "Sam", "Bill"), "or")
# "Bob, John, Sam, or Bill"
}

}
