% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npde.R
\name{npde.cens.method}
\alias{npde.cens.method}
\alias{computenpde.omit}
\alias{computenpde.loq}
\title{Method used to handle censored data}
\value{
This is not a function and does not have a return value, this is a statistical method.

More details can be found in the PDF documentation.
}
\description{
Specifies the method used to handle censored data (data below the limit of quantification LOQ
}
\details{
Several methods are available to handle censored data.
\describe{
\item{omit}{pd and npde for censored data will be set to NA}
\item{cdf}{for an observation ycens_ij under the LOQ, a pd_ij will be imputed in the uniform distribution [0-pLOQ_ij] where pLOQ_ij is the probability that y_ij is below LOQ, according to the model; 
the predictive distribution will then be used to obtain a corresponding y*_ij. 
This is also performed for all simulated data, and the npde are then computed on the completed dataset containing the observed y_ij for the uncensored data and the y*_ij imputed for the censored data. This method is the default.}
\item{ipred}{an observation ycens_ij is replaced by the individual prediction according to the model (ipred, which must be present in the dataset). Simulated data are left untouched.}
\item{ppred}{an observation ycens_ij is replaced by the population prediction according to the model. Simulated data are left untouched.}
\item{loq}{an observation ycens_ij is replaced by the value of the LOQ. Simulated data are left untouched.}
}
}
\examples{
\donttest{
  data(warfarin)
  data(simwarfarinCov)
  wcov<-autonpde(namobs=warfarin,namsim=simwarfarinCov, iid=1,ix=2,iy=4,icov=c(3,6:8),
  namsav="warfCov", units=list(x="hr",y="mg/L", covariates=c("mg","kg","-","yr")))
  
  # Diagnostic plots for warfarin with a covariate model
  plot(wcov)
  
  # Covariate plots
  xwt.scatt<-plot(wcov, plot.type="x.scatter", covsplit=TRUE, which.cov="wt")
  xwt.qqplot<-plot(wcov, plot.type="qqplot", covsplit=TRUE, which.cov="wt")
  xwt.box<-plot(wcov, plot.type="covariates", which.cov="wt")
  xsex.scatt<-plot(wcov, plot.type="x.scatter", covsplit=TRUE, which.cov="sex")
  xsex.qqplot<-plot(wcov, plot.type="qqplot", covsplit=TRUE, which.cov="sex")
  xsex.box<-plot(wcov, plot.type="covariates", which.cov="sex")
  
  # Transforming the reference profile for npd, compared to a VPC plot
  plot.tnpd<-plot(wcov, plot.type="x.scatter", ref.prof=list(id=2), 
  main="tnpd with reference profile ID=2")
  plot.vpc<-plot(wcov, plot.type="vpc", main="VPC")
  grid.arrange(grobs=list(plot.tnpd, plot.vpc), nrow=1, ncol=2)
}

}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.
Mentre. Metrics for external model evaluation with an application to the
population pharmacokinetics of gliclazide. \emph{Pharmaceutical Research},
23:2036--49, 2006.
}
\keyword{methods}
