% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nparml.R
\name{nparml}
\alias{nparml}
\title{Nonparametric Test For Multivariate Data With Two-Way Layout Factorial Design - Large Samples}
\usage{
nparml(formula, data)
}
\arguments{
\item{formula}{an object of class "formula" with two explanatory variables (factors), see examples.}

\item{data}{an object of class "data.frame" containing the variables in the formula}
}
\value{
Returns a list of data frames providing the values of the test statistics, p-values, degrees of freedom, factor levels,
and groupsize per factor level combination.
}
\description{
Analysis of multivariate data with two-way completely randomized
factorial design - version for large samples. The analysis is based on fully nonparametric, rank-based methods and
uses an F-approximation for 'Dempster's ANOVA' criterion and a chisquare-approximation for 'Lawley-Hotelling's'
criterion. This approximations are given by the asymtotic distribution
of these statistics under true null-hypothesis. In contrast to the normal-approximated test (nrbtest2) it is designed for
data with large samples (see details) while the number of factorial levels is allowed to be small. The multivariate response is allowed to be ordinal, quantitative, binary or a mixture
of the different variable types. The test statistics are constructed using nonparametric relative effect estimators.
}
\details{
The data is analysed for main effects
and interaction effect of the explanatory factors. In each case the null hypothesis "no effect" is testet. In order to obtain
reliable results the considered data should include at least 7 observations per factor level combination.
This method is only implemented for complete data sets without missing values.
}
\examples{
data(pseudostudy1)
nparml(resp1|resp2|resp3~treatment*age, pseudostudy1)
}
\references{
Bathke A.C., Harrar S.W. (2016)
Rank-Based Inference for Multivariate Data in Factorial Designs.
In: Liu R., McKean J. (eds) Robust Rank-Based and Nonparametric Methods.
Springer Proceedings in Mathematics & Statistics, vol 168. Springer, Cham

Harrar S.W., Bathke A.C. (2012)
A modified two-factor multivariate analysis of variance:
asymptotics and small sample approximations (and erratum).
In: Annals of the Institute of Statistical Mathematics, 64(1&5):135-165&1087, 2012.

Brunner E., Dette H., Munk A. (1997)
Box-Type Approximations in Nonparametric Factorial Designs
In: Journal of the American Statistical Association, 92(440):1494-1502
}
