% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.intervals.R
\name{random.intervals}
\alias{random.intervals}
\title{Generate random intervals}
\usage{
random.intervals(n, M, min.length = 1, max.length = n, ...)
}
\arguments{
\item{n}{a number of endpoints to choose from}

\item{M}{a number of intervals to generate}

\item{min.length}{an integer specifying minimum interval length}

\item{max.length}{an integer specifying maximum interval length}

\item{...}{not in use}
}
\value{
a \code{M} by 2 matrix with start (first column) and end (second column) points of an interval in each row
}
\description{
The function generates \code{M} intervals of the length smaller or equal than \code{max.length}, whose endpoints are 
are drawn uniformly without replacements from \code{1},\code{2},..., \code{n}. This routine can be
used inside \code{\link{not}} function and is typically not called directly by the user.
}
\examples{
#*** draw 100 intervals with the endpoints in 1,...,100
intervals <- random.intervals(50, 100)
}
\seealso{
\code{\link{not}}
}
