% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single-none.R
\name{singleNone}
\alias{singleNone}
\title{Single-host pathogen in a homogeneous host population}
\usage{
singleNone(
  length.sim,
  max.infected,
  init.individuals,
  pExit,
  param.pExit,
  timeDep.pExit = FALSE,
  nContact,
  param.nContact,
  timeDep.nContact = FALSE,
  pTrans,
  param.pTrans,
  timeDep.pTrans = FALSE,
  prefix.host = "H",
  print.progress = TRUE,
  print.step = 10
)
}
\arguments{
\item{length.sim}{specifies the length (in unit of time) over which the simulation should be run.}

\item{max.infected}{specifies the maximum number of hosts that can be infected in the simulation.}

\item{init.individuals}{number of initially infected individuals.}

\item{pExit}{function that gives the probability to exit the simulation for an infected host (either moving out, dying, etc.).}

\item{param.pExit}{parameter names (list of functions) for the pExit.}

\item{timeDep.pExit}{is pExit dependent on the absolute time of the simulation? (TRUE/FALSE)}

\item{nContact}{function that gives the number of potential transmission events per unit of time.}

\item{param.nContact}{parameter names (list of functions) for param.nContact.}

\item{timeDep.nContact}{is nContact dependent on the absolute time of the simulation? (TRUE/FALSE)}

\item{pTrans}{function that gives the probability of transmit a pathogen as a function of time since infection.}

\item{param.pTrans}{parameter names (list of functions) for the pExit.}

\item{timeDep.pTrans}{is pTrans dependent on the absolute time of the simulation? (TRUE/FALSE)}

\item{prefix.host}{character(s) to be used as a prefix for the hosts identification number.}

\item{print.progress}{if TRUE, displays a progress bar (current time/length.sim).}

\item{print.step}{print.progress is TRUE, step with which the progress message will be printed.}
}
\value{
An object of class \code{\link{nosoiSim}}, containing all results of the simulation.
}
\description{
This function, that can be wrapped within \code{\link{nosoiSim}}, runs a single-host transmission chain simulation, without any structure features in the host population. The simulation stops either at
the end of given time (specified by \code{length.sim}) or when the number of hosts infected threshold (\code{max.infected}) is crossed.
}
\details{
The \code{pExit} and \code{pTrans} functions should return a single probability (a number between 0 and 1), and \code{nContact} a positive natural number (positive integer) or 0.

The \code{param} arguments should be a list of functions or NA. Each item name in the parameter list should have the same name as the argument in the corresponding function.

The use of \code{timeDep} (switch to \code{TRUE}) makes the corresponding function use the argument \code{prestime} (for "present time").
}
\section{Order of Arguments}{

The user specified function's arguments should follow this order: \code{t} (mandatory), \code{prestime} (optional, only if timeDep is TRUE), \code{parameters} specified in the list.
}

\examples{
\donttest{
t_incub_fct <- function(x){rnorm(x,mean = 5,sd=1)}
p_max_fct <- function(x){rbeta(x,shape1 = 5,shape2=2)}
p_Exit_fct  <- function(t){return(0.08)}

proba <- function(t,p_max,t_incub){
 if(t <= t_incub){p=0}
 if(t >= t_incub){p=p_max}
 return(p)
}

time_contact <- function(t){round(rnorm(1, 3, 1), 0)}

test.nosoi <- nosoiSim(type="single", popStructure="none",
                      length=40,
                      max.infected=100,
                      init.individuals=1,
                      nContact=time_contact,
                      param.nContact=NA,
                      pTrans = proba,
                      param.pTrans = list(p_max=p_max_fct,
                                          t_incub=t_incub_fct),
                      pExit=p_Exit_fct,
                      param.pExit=NA)

test.nosoi
}
}
\seealso{
For simulations with a discrete structured host population, see \code{\link{singleDiscrete}}. For simulations with a structured population in continuous space, \code{\link{singleContinuous}}
}
