% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample_dat_scale}
\alias{resample_dat_scale}
\alias{resample_dat_scale_naretainer}
\alias{resample_dat_scale_alt}
\alias{resample_dat_scale_alt_na}
\alias{resample_dat_scale_alt_bf_na}
\alias{resample_dat_scale_alt_bfv}
\alias{resample_dat_scale_optimus}
\alias{resample_dat_scale_optimus_na}
\alias{resample_dat_scale_optimus_backend}
\alias{resample_vect_scale}
\title{A function to create an attribute or column for each sample loaded into the microplate wells.}
\usage{
resample_dat_scale(df, tnp, cycles)

resample_dat_scale_naretainer(df, tnp, cycles)

resample_dat_scale_alt(df, tnp, cycles, na_omit = NULL)

resample_dat_scale_alt_na(df, tnp, cycles)

resample_dat_scale_alt_bf_na(df, tnp, cycles)

resample_dat_scale_alt_bfv(df, tnp, cycles)

resample_dat_scale_optimus(df, tnp, cycles)

resample_dat_scale_optimus_na(df, tnp, cycles)

resample_dat_scale_optimus_backend(df, tnp, cycles, na_omit = NULL)

resample_vect_scale(df, tnp, cycles, method = c("normal", "brute", "vector"))
}
\arguments{
\item{df}{A clean data frame with attributes or tuples containing a mixture of samples.}

\item{tnp}{A numeric value indicating the number of rows used. TNP is used as an acronym for Test, Negative, Positive.}

\item{cycles}{A numeric value indicating the number of cycles selected by the user when running the FLUOstar instrument.}

\item{na_omit}{Takes a string "yes" OR "no".}

\item{method}{A string 'normal', 'brute' or 'vector' to specify the method of resampling.}
}
\value{
A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.
}
\description{
Creates a data frame where each sample loaded into the microplate wells has a separate attribute.

Creates a data frame where each sample loaded into the microplate wells has a separate attribute.
NA values are retained for more control.

A function that takes tuples or rows consisting of several samples and perform a
putative resampling to yield another data frame with a separate attribute for each
sample.

A function that takes tuples or rows consisting of several samples and perform a
putative resampling to yield another data frame with a separate attribute for each
sample. NA values are retained.

A function that takes tuples or rows consisting of several samples and perform a
putative resampling to yield another data frame with a separate attribute for each
sample.

A function that takes tuples or rows consisting of several samples and perform a
putative resampling to yield another data frame with a separate attribute for each
sample.

Creates a data frame where each sample loaded into the microplate wells has a separate attribute.

Creates a data frame where each sample loaded into the microplate wells has a separate attribute.
NA values are retained.

Creates a data frame where each sample loaded into the microplate wells has a separate attribute.

Creates a data frame where each sample loaded into the microplate wells has a separate attribute.
}
\note{
This function builds on or scales-up  @seealso \code{\link[=resample_dat]{resample_dat()}}, hence the suffix scale.
This function is less optimized than @seealso \code{\link[=resample_dat_scale_optimus]{resample_dat_scale_optimus()}}.

This function builds on or scales-up  @seealso \code{\link[=resample_dat]{resample_dat()}}, hence the suffix scale.
This function is less optimized than @seealso \code{\link[=resample_dat_scale_optimus]{resample_dat_scale_optimus()}}.

This function builds on or scales-up  @seealso \code{\link[=resample_dat]{resample_dat()}}, hence the suffix scale.
This function is more optimized than @seealso \code{\link[=resample_dat_scale]{resample_dat_scale()}}, hence the suffix scale_optimus.

This function builds on or scales-up  @seealso \code{\link[=resample_dat]{resample_dat()}}, hence the suffix scale.
This function is more optimized than @seealso \code{\link[=resample_dat_scale]{resample_dat_scale()}}, hence the suffix scale_optimus.

This function builds on or scales-up  @seealso \code{\link[=resample_dat]{resample_dat()}}, hence the suffix scale.
This function is more optimized than @seealso \code{\link[=resample_dat_scale]{resample_dat_scale()}}, hence the suffix scale_optimus.

This is the pseudo-vectorized approach and should be a more efficient function.
This function will produce a vertical layout as defined in this package.
This function inspired by the lapply approach pretty much applies the
}
\examples{
\dontrun{
fpath <- system.file("extdata", "dat_4.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_4.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_naretainer(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_alt(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_alt_na(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_4.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_alt_bf_na(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_4.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_alt_bfv(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_optimus(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_optimus_na(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_optimus_backend(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_3.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
alt_test_scale <- resample_vect_scale(nocomma_dat,3,40, method = 'brute')
alt_test_scale <- resample_vect_scale(nocomma_dat,3,40, method = 'normal')
alt_test_scale <- resample_vect_scale(nocomma_dat,3,40, method = 'vector')
alt_test_scale_norm <- lapply(alt_test_scale, min_max_norm)}
}
\seealso{
\code{\link[=resample_dat]{resample_dat()}}

\code{\link[=resample_dat]{resample_dat()}}

\code{\link[=resample_dat_alt]{resample_dat_alt()}}

\code{\link[=resample_dat_alt]{resample_dat_alt()}}

\code{\link[=resample_dat_alt]{resample_dat_alt()}}, \code{\link[=resample_dat_scale_alt]{resample_dat_scale_alt()}}

\code{\link[=resample_dat_alt]{resample_dat_alt()}}, \code{\link[=resample_dat_scale_alt]{resample_dat_scale_alt()}}

\code{\link[=resample_dat]{resample_dat()}}

\code{\link[=resample_dat]{resample_dat()}}

\code{\link[=resample_dat]{resample_dat()}}

\code{\link[=resample_dat_vect]{resample_dat_vect()}}

\code{\link[=resample_dat_vect]{resample_dat_vect()}}. As a matter of fact, I took this approach to
create compatibility with lapply and rapply but that failed.
}
\author{
Tingwei Adeck
}
