% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntdbf_subordinates.R
\name{unique_identifier}
\alias{unique_identifier}
\title{Title: A function to append a unique identifier attribute to any data frame within the normfluodbf package.}
\usage{
unique_identifier(df)
}
\arguments{
\item{df}{A data frame with 1:n number of rows.}
}
\value{
A data frame with the Cycle_Number attribute appended to the end of the data frame.
}
\description{
The function in the context of normfluodbf creates an attribute called Cycle_Number
and appends this attribute to the cleaned or wrangled data frame derived from the dirty DBF file.
}
\note{
The function operates in a closed system,
meaning it is primarily designed to work with this package ONLY.
Other use cases are simply a coincidence.
}
\examples{
test_df <- as.data.frame(c(seq(40)))
colnames(test_df) <- "test"
unique_identifier(test_df)
}
\seealso{
\code{\link[=normfluodat]{normfluodat()}}, \code{\link[=norm_tidy_dbf]{norm_tidy_dbf()}}, \code{\link[=normfluordbf]{normfluordbf()}}, \code{\link[=generic_identifier]{generic_identifier()}}
}
\author{
Tingwei Adeck
}
