% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normfluodat.R
\name{normfluodat}
\alias{normfluodat}
\title{Title: Cleans and normalizes DAT files obtained from experiments using the FLUOstar Omega microplate reader (from BMG LABTECH).}
\usage{
normfluodat(
  dat,
  tnp,
  cycles,
  rows_used = NULL,
  cols_used = NULL,
  user_specific_labels = NULL,
  read_direction = NULL,
  norm_scale = NULL
)
}
\arguments{
\item{dat}{A string ("dat_1.dat") if the file is found within the present working directory (pwd) OR a path pointing directly to a ".dat" file.}

\item{tnp}{A numeric value indicating the number of rows used. TNP is used as an acronym for Test, Negative, Positive.}

\item{cycles}{A numeric value indicating the number of cycles selected by the user when running the FLUOstar instrument.}

\item{rows_used}{A character vector of the rows used; ru = c('A','B','C').}

\item{cols_used}{A numeric vector of the columns used; cu = c(1,2,3).}

\item{user_specific_labels}{A character vector manually prepared by the user to denote the wells used on the microplate reader; usl = c('A1','B1','C1').}

\item{read_direction}{A string input with two choices, “vertical” or “horizontal.”
The user indicates “vertical” if the user intends to have a final data frame with
samples arranged as sample type triplets (A1, B1, C1, A1, B1, C1) OR “horizontal”
if the user intends to have a final data frame with samples arranged as clusters per sample type (A1, A2, A3, B1, B2, B3).}

\item{norm_scale}{This parameter takes sub-parameters: 'raw’ , hundred’ , 'one’ , 'z-score' , or 'decimal’ ,
which denotes the normalization type or scale; Initialized as NULL.}
}
\value{
A normalized data frame with an appended "Cycle_Number" attribute. The “Cycle_Number” attribute is the X-variable.
}
\description{
The simplest case scenario entails inputting the name or directory of a DAT file as a string,
the number of rows denoted by the tnp (test, negative, positive) parameter,
and the number of cycles (selected by the user when running the FLUOstar instrument).
The program takes these three baseline parameters, performs cleaning and normalization of the DAT file,
and then appends an attribute called “Cycle_Number” to the normalized data frame.
}
\note{
This function is a single-step function leveraging several subordinate functions.
It is assumed that the user has the 3 baseline parameters to get this function working.
Users must double-check attribute names to ensure they end up with accurate results.
}
\examples{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
normalized_fluo_dat <- normfluodat(dat=fpath, tnp = 3, cycles = 40)
}
\seealso{
\code{\link[=normfluordat]{normfluordat()}}
}
\author{
Tingwei Adeck
}
