% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likebut.R
\name{likebut}
\alias{likebut}
\title{Modify a Model}
\usage{
likebut(x, but = "better", y = NULL, project = getOption("project",
  getwd()), nested = getOption("nested", TRUE), overwrite = FALSE,
  ext = getOption("modex", "ctl"), include = "\\\\.def$", ...)
}
\arguments{
\item{x}{a model name, presumably interpretable as numeric}

\item{but}{a short description of the characteristic difference from x}

\item{y}{optional name for model to be created, auto-incremented by default}

\item{project}{project directory}

\item{nested}{model files nested in run-specific directories}

\item{overwrite}{whether to overwrite y if it exists}

\item{ext}{extension for the model file}

\item{include}{regular expressions for files to copy to new directory}

\item{...}{passed arguments}
}
\value{
the value of y
}
\description{
Makes a copy of a model in a corresponding directory.  Problem statement is
updated to reflect that the model is LIKE the reference model BUT different
in some fundamental way.
}
\examples{
# Create a working project.
source <- system.file(package = 'nonmemica','project')
target <- tempdir()
target <- gsub('\\\\\\\\','/',target) # for windows
source
target
file.copy(source,target,recursive = TRUE)
project <- file.path(target,'project','model')

# Point project option at working project
options(project = project)
library(magrittr)

# Derive models.
1001 \%>\% likebut('revised',y = 1002, overwrite=TRUE )

# At this point, edit 1002.ctl to match whatever 'revised' means.
# Then run it with NONMEM.
}
