% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_GOFs.R
\name{basic.eta.GOF}
\alias{basic.eta.GOF}
\alias{eta.hist.GOF}
\alias{eta.qqnorm.GOF}
\title{Histogram and/or QQ-norm GOF for ETA's}
\usage{
basic.eta.GOF(data, title = "", global.ggplot.options = NULL,
  type = c("both", "qqnorm", "hist"), refline = TRUE,
  drop.fixed = TRUE, id.column = "ID", standardize = TRUE,
  bins = NA, control = GOF.control())

eta.hist.GOF(data, title = "", drop.fixed = TRUE, refline = TRUE,
  id.column = "ID", standardize = TRUE, bins = NA,
  control = GOF.control())

eta.qqnorm.GOF(data, title = "", drop.fixed = TRUE, refline = TRUE,
  id.column = "ID", standardize = TRUE, control = GOF.control())
}
\arguments{
\item{data}{data.frame to plot}

\item{title}{title}

\item{global.ggplot.options}{ggplot option added to  each ggplot before plotting/returning object}

\item{type}{do only qq-norm plots (qqnorm), only histograms (hist), or do both (both)}

\item{refline}{add reference line (default =TRUE) or not (FALSE)}

\item{drop.fixed}{drop ETA's that are fixed, i.e. any ETA with the same value in all subjects}

\item{id.column}{column name that indicate subject identifier}

\item{standardize}{Standardize all ETA's  (e.g. scale to unit variance)}

\item{bins}{number of histogram bins, if NA, bins are set using Sturges' formula}

\item{control}{an optional list of control settings. See GOF.control for the names of the settable control values and their effect.}
}
\description{
Provides histogram and/or QQ-norm GOF for all ETA's included in the input data.frame with
caption added as reurned by get.caption
}
\examples{
# Get path to the example files included in nonmem2R package
file1 <- system.file("extdata", "sdtab999", package = "nonmem2R")
sdtab<-read.table(file=file1,skip=1,header=TRUE)
set.script.name("MyScript.R")
basic.eta.GOF(sdtab)
}
