% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPCs_ggplot.R
\name{vpcfig2}
\alias{vpcfig2}
\title{Visual Predictive Check (VPC) based on Perl-speaks-NONMEM (PsN) generated VPC files (ggplot2-version).}
\usage{
vpcfig2(vpcdir = NULL, vpctab = NULL, vpcresult = NULL,
  strata.names = NULL, strata.subset = NULL, percentile = 10,
  fy = function(y) {     y }, fx = function(x) {     x }, xlab = NULL,
  ylab = NULL, col.data = "gray20", cex.data = 1, pch.data = 19,
  alpha.data = 0.5, col.line = "grey20", lwd.line = 1, lty.line = c(2,
  1, 2), col.segm = c("steelblue", "gray50", "steelblue"), alpha.segm = 0.6,
  type = 3)
}
\arguments{
\item{vpcdir}{Path of directory of the VPC files}

\item{vpctab}{Path to the vpctab-file}

\item{vpcresult}{Path to the vpcresult file}

\item{strata.names}{Character vector for strata names. Must have length equal to number of strata's in vpc files, otherwise ignored.}

\item{strata.subset}{Vector specifying subset of strata to use. Either a vector of index, e.g.  strata.subset=c(1,3),
or a character vector naming which strata to use. See details.}

\item{percentile}{percentile to use, default=10 will display 10% 50% and 90% percentile for model and data.
Percentile argument must match columns included in the vpcresult file.}

\item{fy}{transformation function for y-axis, default to identity function (f(y)=y).}

\item{fx}{transformation function for x-axis, default to identity function (f(x)=x)}

\item{xlab}{label for x-axis, default is IDV as found in vpcresultfile, passed to labs.}

\item{ylab}{label for y-axis, default is DV as found in vpcresultfile, passed to labs.}

\item{col.data}{color for data points, passed to geom_point, default="gray20"}

\item{cex.data}{cex for data points, passed to geom_point, default=1}

\item{pch.data}{plot symbol (pch) for data points, passed to geom_point, default=19}

\item{alpha.data}{alpha for plotting of data points, passed to geom_point, default=0.5}

\item{col.line}{line color for low quartile, median, and high quartile of data,
passed to geom_line, default="gray20"}

\item{lwd.line}{line width (lwd) for low quartile, median, and high quartile of data, passed to geom_line, default=1}

\item{lty.line}{line type (lty) for low quartile, median, and high quartile of data, passed to geom_line,
should be vector of length 3, default=c(2,1,2)}

\item{col.segm}{Color of CI regions (low, median and high) for model, passed to geom_polygon,
should be vector of length 3, default=c("steelblue", "gray50", "steelblue")}

\item{alpha.segm}{alpha of CI regions (low, median and high) for model, passed to geom_polygon, default=0.6}

\item{type}{type of VPC plot, 1=display model regions only, 2=as 1 + lines (low, median and high) of data,
3= as 2 + points for data.
type=0 can also be used and then no graph is produced but instead a list with 2 dataframes is returned.
one for the vpcresult and on for the observed data in the vpctab file.}
}
\value{
ggplot object of VPC plot
}
\description{
This function creates VPC using output files from the vpc command in Pearl Speaks NONMEM (PsN).
Graphs are generated using the ggplot2 package and the return object is an ggplot class and
can be further modified, see details below and documentation for ggplot2 for further details.
}
\details{
The ggplot2 package is used for creating the VPC and vpcfig2 have functionality for e.g. modify
names of strata, order of and subset of strata's, and transform the x- and or y-axis before plotting.

The data used is either specified by the directory of the PsN generated files,
or by specifying the file names of both the vpctab-file and the vpcresult file.
See examples 1 and 2 below.

Names of strata can be changed with the strata.names argument, if strata.names
is NULL the names as specified in the vpcresult file are used.

strata.subset can be used to select a subset of strata, and or to change the order of stratas. Se example 3.
NOTE: strata.subset is matched with strata.names unless strata.names=NULL.
If strata.names=NULL then strata.subset is matched to names as specified in vpcresult file.
Default is to use all strata's (strata.subset=NULL).

The fy and fx arguments can be used to alter the scale of data plotted. For example, using fy=function(y){log(y+1)}
is a convenient way to get log-scale for y-axis but with an off-set to show any values==0.
Proper y tick marks can then be set using the scale_y_continuous ggplot2 function.

Since the returned objest is a ggplot-class object is can be further modified to e.g. to log-scale for y.axis;
vpcfig2(...)+scale_y_log10(),  adding/changing labels & titles;
vpcfig2(...)+labs(y="Modified y-label", title="New title"), etc.
See examples below and documentation for ggplot2 for further details.
}
\examples{

# Get path to the example files included in nonmem2R package
file1 <- system.file("extdata", "vpctab004.dat", package = "nonmem2R")
file2 <- system.file("extdata", "vpc_results.csv", package = "nonmem2R")


# Ex 1, produce VPC with default setting, here specifying both vpctab and vpcresult
vpcfig2(vpctab=file1,vpcresult=file2)

\dontrun{
# Ex 2, produce VPC with default setting, here specifying only directory of vpc files
path1<-gsub("vpctab004.dat","",file1)
vpcfig2(vpcdir=path1)
}

# Ex 3, produce VPC with i) modifies strata names, ii) strata in reverse order, and
#        iii) labels
strata.names<-c("Group A","Group B")
xlab<-"Time after dose (hrs)"
ylab<-"Plasma Conc(mmol/L)"
vpcfig2(vpctab=file1,vpcresult=file2,strata.names=strata.names,strata.subset=2:1,
       xlab=xlab,ylab=ylab)


# Example using the fy argument to transform y-axis setting y-ticks using scale_y_continuous(...)
tmp<-c(1,2,3,4,6)
yticks<-c(0.1,tmp,tmp*10,tmp*100,tmp*1000)
vpcfig2(vpctab=file1,vpcresult=file2,fy=function(y){log(y+1)})+
 scale_y_continuous(breaks=log(yticks+1),labels=yticks,minor_breaks=NULL)

\dontrun{
# Example changing to slog-scale using the ggplot2 function scale_y_log10
vpcfig2(vpctab=file1,vpcresult=file2)+scale_y_log10()
}
# Example changing y-axis label and adding figure title using ggplot2 function labs(...).
vpcfig2(vpctab=file1,vpcresult=file2)+labs(y="Modified y-label", title="New title")


}

