% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nomnoml.R
\name{nomnoml}
\alias{nomnoml}
\title{Render Diagram}
\usage{
nomnoml(code = "[Hello]-[World!]", png = NULL, width = NULL,
  height = NULL, ...)
}
\arguments{
\item{code}{The nomnoml diagram code.}

\item{png}{Optional file name to export diagram as 'png'.}

\item{width}{Optional width in pixels for the exported 'png'.}

\item{height}{Optional height in pixels for the exported 'png'.}

\item{...}{Additional parameters.}
}
\description{
Renders a 'nomnoml' diagram as an 'htmlwidget' or saves it
as a 'png' image.
}
\details{
The 'nomnoml' syntax is simple and intuitive, a "Hello World"
example can be rendered as an 'htmlwidget' as follows:

\code{nomnoml::nomnoml("[Hello]-[World!]", "orange")}

You can also render as a 'png' file with specific dimensions:

\code{nomnoml::nomnoml("[Hello]-[World!]", "hello.png", 600, 100)}

Still, complex diagrams can be defined by combining multiple
association types, classifier types, directives and
custom classifier styles.

You can also use of the \code{nomnoml} 'knitr' chunk
to render inline diagrams in R Markdown documents.
}
\section{Association Types}{


\code{association -}

\code{association ->}

\code{association <->}

\code{dependency -->}

\code{dependency <-->}

\code{generalization -:>}

\code{generalization <:-}

\code{implementation --:>}

\code{implementation <:--}

\code{composition +-}

\code{composition +->}

\code{aggregation o-}

\code{aggregation o->}

\code{note --}

\code{hidden -/-}
}

\section{Classifier Types}{


\code{[name]}

\code{[<abstract> name]}

\code{[<instance> name]}

\code{[<note> name]}

\code{[<reference> name]}

\code{[<package> name]}

\code{[<frame> name]}

\code{[<database> name]}

\code{[<start> name]}

\code{[<end> name]}

\code{[<state> name]}

\code{[<choice> name]}

\code{[<input> name]}

\code{[<sender> name]}

\code{[<receiver> name]}

\code{[<transceiver> name]}

\code{[<actor> name]}

\code{[<usecase> name]}

\code{[<label> name]}

\code{[<hidden> name]}
}

\section{Directives}{


\code{#arrowSize: 1}

\code{#bendSize: 0.3}

\code{#direction: down | right}

\code{#gutter: 5}

\code{#edgeMargin: 0}

\code{#edges: hard | rounded}

\code{#fill: #eee8d5; #fdf6e3}

\code{#fillArrows: false}

\code{#font: Calibri}

\code{#fontSize: 12}

\code{#leading: 1.25}

\code{#lineWidth: 3}

\code{#padding: 8}

\code{#spacing: 40}

\code{#stroke: #33322E}

\code{#title: filename}

\code{#zoom: 1}
}

\section{Custom Classifier Styles}{


A directive that starts with \code{.} define a classifier style.
The style is written as a space separated list of modifiers and
key/value pairs.

\code{#.box: fill=#8f8 dashed}

\code{#.blob: visual=ellipse}

\code{[<box> GreenBox]}

\code{[<blob> HideousBlob]}

Available key/value pairs are:

\code{fill=(any css color)}

\code{stroke=(any css color)}

\code{align=center}

\code{align=left}

\code{direction=right}

\code{direction=down}

\code{visual=actor}

\code{visual=class}

\code{visual=database}

\code{visual=ellipse}

\code{visual=end}

\code{visual=frame}

\code{visual=hidden}

\code{visual=input}

\code{visual=none}

\code{visual=note}

\code{visual=package}

\code{visual=receiver}

\code{visual=rhomb}

\code{visual=roundrect}

\code{visual=sender}

\code{visual=start}

\code{visual=transceiver}

Available modifiers are:

\code{bold}

\code{underline}

\code{italic}

\code{dashed}

\code{empty}
}

\examples{
# Render simple diagram:
nomnoml::nomnoml("[Hello]-[World!]")

# Render complex diagram:
nomnoml::nomnoml("
  #stroke: #a86128
  [<frame>Decorator pattern|
    [<abstract>Component||+ operation()]
    [Client] depends --> [Component]
    [Decorator|- next: Component]
    [Decorator] decorates -- [ConcreteComponent]
    [Component] <:- [Decorator]
    [Component] <:- [ConcreteComponent]
  ]")

}
