% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eskin.R
\name{eskin}
\alias{eskin}
\title{Eskin (ES) Measure}
\usage{
eskin(data)
}
\arguments{
\item{data}{A \emph{data.frame} or a \emph{matrix} with cases in rows and variables in colums.}
}
\value{
The function returns a dissimilarity matrix of the size \code{n x n}, where \code{n} is the number of objects in the original dataset in the argument \code{data}.
\cr
}
\description{
A function for calculation of a proximity (dissimilarity) matrix based on the ES similarity measure.
}
\details{
The Eskin similarity measure was proposed by Eskin et al. (2002) and examined by Boriah et al., (2008). It is constructed to assign
higher weights to mismatches on variables with more categories.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.eskin <- eskin(data20)
}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Eskin E., Arnold A., Prerau M., Portnoy L. and Stolfo S. (2002). A geometric framework for unsupervised anomaly detection.
In D. Barbara and S. Jajodia (Eds): Applications of Data Mining in Computer Security, p. 78-100. Norwell: Kluwer Academic Publishers.
}
\seealso{
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{morlini}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
