% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denominator.R
\name{denominator}
\alias{denominator}
\alias{nom_denom}
\title{Convert numbers to denominator character vectors (whole, half, third)}
\usage{
denominator(x, numerator = 1, quarter = TRUE, ...)

nom_denom(x, numerator = 1, quarter = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector}

\item{numerator}{A numeric vector.
The numerator(s) associated with the denominator(s).
When \code{numerator} is not \code{1} or \code{-1}, the denominator will be pluralized.}

\item{quarter}{A logical of length one.
If \code{TRUE}, the denominator of \code{4} will be "quarter(s)".
If \code{FALSE}, the denominator of \code{4} will be "fourth(s)".
Defaults to \code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link[=ordinal]{ordinal()}}}
}
\value{
A character vector of the same length as \code{x}
}
\description{
Convert numbers to denominator character vectors (whole, half, third)
}
\examples{
nom_denom(2)
nom_denom(1:10)
nom_denom(1:10, numerator = 2)
nom_denom(1:10, numerator = 1:10)

nom_denom(4)
nom_denom(4, quarter = FALSE)

nom_denom(1:10, numerator = 2, cardinal = FALSE)
nom_denom(5:15, numerator = 2, max_n = 10)
}
\seealso{
Other number names: 
\code{\link{adverbial}()},
\code{\link{cardinal}()},
\code{\link{collective}()},
\code{\link{numerator}()},
\code{\link{ordinal}()},
\code{\link{ratio}()}
}
\concept{number names}
